/************************************************************************************************/
/* Stata User File for H50 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H50.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H50.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H50.DO                                               */
/* The program below will output the Stata dataset H50.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL00 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID00 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  str    HIEUIDX 30-41
  byte   FCSZ1231 42-43
  byte   FCRP1231 44-45
  str    RULETR31 46-47
  str    RULETR42 48-49
  str    RULETR53 50-51
  str    RULETR00 52-53
  byte   RUSIZE31 54-55
  byte   RUSIZE42 56-57
  byte   RUSIZE53 58-59
  byte   RUSIZE00 60-61
  byte   RUCLAS31 62-63
  byte   RUCLAS42 64-65
  byte   RUCLAS53 66-67
  byte   RUCLAS00 68-68
  byte   FAMSZE31 69-70
  byte   FAMSZE42 71-72
  byte   FAMSZE53 73-74
  byte   FAMSZE00 75-76
  byte   FMRS1231 77-78
  byte   FAMS1231 79-80
  byte   FAMSZEYR 81-82
  byte   FAMRFPYR 83-84
  byte   REGION31 85-86
  byte   REGION42 87-88
  byte   REGION53 89-90
  byte   REGION00 91-92
  byte   MSA31 93-94
  byte   MSA42 95-96
  byte   MSA53 97-98
  byte   MSA00 99-100
  int    REFPRS31 101-103
  int    REFPRS42 104-106
  int    REFPRS53 107-109
  int    REFPRS00 110-112
  byte   RESP31 113-113
  byte   RESP42 114-114
  byte   RESP53 115-115
  byte   RESP00 116-116
  byte   PROXY31 117-118
  byte   PROXY42 119-120
  byte   PROXY53 121-122
  byte   PROXY00 123-123
  byte   INTVLANG 124-125
  byte   BEGRFD31 126-127
  byte   BEGRFM31 128-129
  int    BEGRFY31 130-133
  byte   ENDRFD31 134-135
  byte   ENDRFM31 136-137
  int    ENDRFY31 138-141
  byte   BEGRFD42 142-143
  byte   BEGRFM42 144-145
  int    BEGRFY42 146-149
  byte   ENDRFD42 150-151
  byte   ENDRFM42 152-153
  int    ENDRFY42 154-157
  byte   BEGRFD53 158-159
  byte   BEGRFM53 160-161
  int    BEGRFY53 162-165
  byte   ENDRFD53 166-167
  byte   ENDRFM53 168-169
  int    ENDRFY53 170-173
  byte   ENDRFD00 174-175
  byte   ENDRFM00 176-177
  int    ENDRFY00 178-181
  byte   KEYNESS 182-182
  byte   INSCOP31 183-183
  byte   INSCOP42 184-184
  byte   INSCOP53 185-185
  byte   INSCOP00 186-186
  byte   INSC1231 187-187
  byte   INSCOPE 188-188
  byte   ELGRND31 189-189
  byte   ELGRND42 190-190
  byte   ELGRND53 191-191
  byte   ELGRND00 192-192
  byte   ELIGIBLE 193-193
  byte   PSTATS31 194-195
  byte   PSTATS42 196-197
  byte   PSTATS53 198-199
  str    RURSLT31 200-201
  str    RURSLT42 202-203
  str    RURSLT53 204-205
  byte   AGE31X 206-207
  byte   AGE42X 208-209
  byte   AGE53X 210-211
  byte   AGE00X 212-213
  byte   DOBMM 214-215
  int    DOBYY 216-219
  byte   SEX 220-220
  byte   RACEX 221-221
  byte   RACETHNX 222-222
  byte   HISPANX 223-223
  byte   HISPCAT 224-225
  byte   MARRY31X 226-227
  byte   MARRY42X 228-229
  byte   MARRY53X 230-231
  byte   MARRY00X 232-233
  int    SPOUID31 234-236
  int    SPOUID42 237-239
  int    SPOUID53 240-242
  int    SPOUID00 243-245
  byte   SPOUIN31 246-247
  byte   SPOUIN42 248-249
  byte   SPOUIN53 250-251
  byte   SPOUIN00 252-253
  byte   EDUCYEAR 254-255
  byte   HIDEGYR 256-257
  byte   FTSTU31X 258-259
  byte   FTSTU42X 260-261
  byte   FTSTU53X 262-263
  byte   FTSTU00X 264-265
  byte   ACTDTY31 266-267
  byte   ACTDTY42 268-269
  byte   ACTDTY53 270-271
  byte   DIDSERVE 272-273
  byte   VETVIET 274-275
  byte   VETKOR 276-277
  byte   VETWW 278-279
  byte   VETOTH 280-281
  byte   RFREL31X 282-283
  byte   RFREL42X 284-285
  byte   RFREL53X 286-287
  byte   RFREL00X 288-289
  int    MOPID31X 290-292
  int    MOPID42X 293-295
  int    MOPID53X 296-298
  int    DAPID31X 299-301
  int    DAPID42X 302-304
  int    DAPID53X 305-307
  byte   SSIDIS00 308-309
  byte   AFDC00 310-311
  byte   FILEDR00 312-313
  byte   WILFIL00 314-315
  byte   FLSTAT00 316-317
  byte   FILER00 318-319
  byte   JTINRU00 320-321
  int    JNTPID00 322-324
  byte   CLMDEP00 325-326
  byte   DEPDNT00 327-328
  byte   DPINRU00 329-330
  byte   DPOTSD00 331-332
  byte   TAXFRM00 333-334
  byte   DEDUCT00 335-336
  byte   ITMEXP00 337-338
  double MEXAMT00 339-346
  double NTMDED00 347-354
  double TOTDED00 355-363
  byte   CLMHIP00 364-365
  byte   ELDISC00 366-367
  byte   EICRDT00 368-369
  int    UNEMTX00 370-372
  int    INTRTX00 373-375
  int    SSECTX00 376-378
  int    IRATAX00 379-381
  byte   FOODST00 382-383
  byte   FOODMN00 384-385
  double FOODCT00 386-391
  double FOODVL00 392-397
  long   TTLP00X 398-403
  byte   POVCAT00 404-404
  long   WAGEP00X 405-410
  byte   WAGIMP00 411-411
  long   BUSNP00X 412-417
  byte   BUSIMP00 418-418
  long   FARMP00X 419-424
  byte   FARIMP00 425-425
  long   UNEMP00X 426-430
  byte   UNEIMP00 431-431
  long   WCMPP00X 432-436
  byte   WCPIMP00 437-437
  long   INTRP00X 438-442
  byte   INTIMP00 443-443
  long   DIVDP00X 444-448
  byte   DIVIMP00 449-449
  long   SALEP00X 450-455
  byte   SALIMP00 456-456
  long   PENSP00X 457-461
  byte   PENIMP00 462-462
  long   SSECP00X 463-467
  byte   SSCIMP00 468-468
  long   TRSTP00X 469-474
  byte   TRTIMP00 475-475
  long   VETSP00X 476-480
  byte   VETIMP00 481-481
  long   IRASP00X 482-486
  byte   IRAIMP00 487-487
  long   REFDP00X 488-492
  byte   REFIMP00 493-493
  long   ALIMP00X 494-498
  byte   ALIIMP00 499-499
  long   CHLDP00X 500-504
  byte   CHLIMP00 505-505
  long   CASHP00X 506-510
  byte   CSHIMP00 511-511
  long   SSIP00X 512-516
  byte   SSIIMP00 517-517
  int    PUBP00X 518-521
  byte   PUBIMP00 522-522
  long   OTHRP00X 523-527
  byte   OTHIMP00 528-528
  byte   EMPST31 529-530
  byte   EMPST42 531-532
  byte   EMPST53 533-534
  byte   RNDFLG31 535-536
  byte   MORJOB31 537-538
  byte   MORJOB42 539-540
  byte   MORJOB53 541-542
  byte   EVRWRK 543-544
  double HRWG31X 545-550
  double HRWG42X 551-556
  double HRWG53X 557-562
  byte   HRWGIM31 563-563
  byte   HRWGIM42 564-564
  byte   HRWGIM53 565-565
  byte   HRHOW31 566-567
  byte   HRHOW42 568-569
  byte   HRHOW53 570-571
  int    HOUR31 572-574
  int    HOUR42 575-577
  int    HOUR53 578-580
  byte   SELFCM31 581-582
  byte   SELFCM42 583-584
  byte   SELFCM53 585-586
  byte   DISVW31X 587-588
  byte   DISVW42X 589-590
  byte   DISVW53X 591-592
  byte   CHOIC31 593-594
  byte   CHOIC42 595-596
  byte   CHOIC53 597-598
  byte   CIND31 599-600
  byte   CIND42 601-602
  byte   CIND53 603-604
  int    NUMEMP31 605-607
  int    NUMEMP42 608-610
  int    NUMEMP53 611-613
  byte   MORE31 614-615
  byte   MORE42 616-617
  byte   MORE53 618-619
  byte   UNION31 620-621
  byte   UNION42 622-623
  byte   UNION53 624-625
  byte   NWK31 626-627
  byte   NWK42 628-629
  byte   NWK53 630-631
  byte   CHGJ3142 632-633
  byte   CHGJ4253 634-635
  byte   YCHJ3142 636-637
  byte   YCHJ4253 638-639
  byte   STJBMM31 640-641
  byte   STJBDD31 642-643
  int    STJBYY31 644-647
  byte   STJBMM42 648-649
  byte   STJBDD42 650-651
  int    STJBYY42 652-655
  byte   STJBMM53 656-657
  byte   STJBDD53 658-659
  int    STJBYY53 660-663
  byte   EVRETIRE 664-665
  byte   COCCP31 666-667
  byte   COCCP42 668-669
  byte   COCCP53 670-671
  byte   BGNWK31 672-673
  byte   BGNWK42 674-675
  byte   BGNWK53 676-677
  byte   ENDWK31 678-679
  byte   ENDWK42 680-681
  byte   ENDWK53 682-683
  byte   PAYVAC31 684-685
  byte   PAYVAC42 686-687
  byte   PAYVAC53 688-689
  byte   SICPAY31 690-691
  byte   SICPAY42 692-693
  byte   SICPAY53 694-695
  byte   PAYDR31 696-697
  byte   PAYDR42 698-699
  byte   PAYDR53 700-701
  byte   RETPLN31 702-703
  byte   RETPLN42 704-705
  byte   RETPLN53 706-707
  byte   SHFTWK31 708-709
  byte   SHFTWK42 710-711
  byte   SHFTWK53 712-713
  byte   BSNTY31 714-715
  byte   BSNTY42 716-717
  byte   BSNTY53 718-719
  byte   JOBORG31 720-721
  byte   JOBORG42 722-723
  byte   JOBORG53 724-725
  byte   HELD31X 726-727
  byte   HELD42X 728-729
  byte   HELD53X 730-731
  byte   OFFER31X 732-733
  byte   OFFER42X 734-735
  byte   OFFER53X 736-737
  byte   TRIJA00X 738-739
  byte   TRIFE00X 740-741
  byte   TRIMA00X 742-743
  byte   TRIAP00X 744-745
  byte   TRIMY00X 746-747
  byte   TRIJU00X 748-749
  byte   TRIJL00X 750-751
  byte   TRIAU00X 752-753
  byte   TRISE00X 754-755
  byte   TRIOC00X 756-757
  byte   TRINO00X 758-759
  byte   TRIDE00X 760-761
  byte   MCRJA00 762-763
  byte   MCRFE00 764-765
  byte   MCRMA00 766-767
  byte   MCRAP00 768-769
  byte   MCRMY00 770-771
  byte   MCRJU00 772-773
  byte   MCRJL00 774-775
  byte   MCRAU00 776-777
  byte   MCRSE00 778-779
  byte   MCROC00 780-781
  byte   MCRNO00 782-783
  byte   MCRDE00 784-785
  byte   MCRJA00X 786-787
  byte   MCRFE00X 788-789
  byte   MCRMA00X 790-791
  byte   MCRAP00X 792-793
  byte   MCRMY00X 794-795
  byte   MCRJU00X 796-797
  byte   MCRJL00X 798-799
  byte   MCRAU00X 800-801
  byte   MCRSE00X 802-803
  byte   MCROC00X 804-805
  byte   MCRNO00X 806-807
  byte   MCRDE00X 808-809
  byte   MCDJA00 810-811
  byte   MCDFE00 812-813
  byte   MCDMA00 814-815
  byte   MCDAP00 816-817
  byte   MCDMY00 818-819
  byte   MCDJU00 820-821
  byte   MCDJL00 822-823
  byte   MCDAU00 824-825
  byte   MCDSE00 826-827
  byte   MCDOC00 828-829
  byte   MCDNO00 830-831
  byte   MCDDE00 832-833
  byte   MCDJA00X 834-835
  byte   MCDFE00X 836-837
  byte   MCDMA00X 838-839
  byte   MCDAP00X 840-841
  byte   MCDMY00X 842-843
  byte   MCDJU00X 844-845
  byte   MCDJL00X 846-847
  byte   MCDAU00X 848-849
  byte   MCDSE00X 850-851
  byte   MCDOC00X 852-853
  byte   MCDNO00X 854-855
  byte   MCDDE00X 856-857
  byte   OPAJA00 858-859
  byte   OPAFE00 860-861
  byte   OPAMA00 862-863
  byte   OPAAP00 864-865
  byte   OPAMY00 866-867
  byte   OPAJU00 868-869
  byte   OPAJL00 870-871
  byte   OPAAU00 872-873
  byte   OPASE00 874-875
  byte   OPAOC00 876-877
  byte   OPANO00 878-879
  byte   OPADE00 880-881
  byte   OPBJA00 882-883
  byte   OPBFE00 884-885
  byte   OPBMA00 886-887
  byte   OPBAP00 888-889
  byte   OPBMY00 890-891
  byte   OPBJU00 892-893
  byte   OPBJL00 894-895
  byte   OPBAU00 896-897
  byte   OPBSE00 898-899
  byte   OPBOC00 900-901
  byte   OPBNO00 902-903
  byte   OPBDE00 904-905
  byte   STAJA00 906-907
  byte   STAFE00 908-909
  byte   STAMA00 910-911
  byte   STAAP00 912-913
  byte   STAMY00 914-915
  byte   STAJU00 916-917
  byte   STAJL00 918-919
  byte   STAAU00 920-921
  byte   STASE00 922-923
  byte   STAOC00 924-925
  byte   STANO00 926-927
  byte   STADE00 928-929
  byte   PUBJA00X 930-931
  byte   PUBFE00X 932-933
  byte   PUBMA00X 934-935
  byte   PUBAP00X 936-937
  byte   PUBMY00X 938-939
  byte   PUBJU00X 940-941
  byte   PUBJL00X 942-943
  byte   PUBAU00X 944-945
  byte   PUBSE00X 946-947
  byte   PUBOC00X 948-949
  byte   PUBNO00X 950-951
  byte   PUBDE00X 952-953
  byte   PEGJA00 954-955
  byte   PEGFE00 956-957
  byte   PEGMA00 958-959
  byte   PEGAP00 960-961
  byte   PEGMY00 962-963
  byte   PEGJU00 964-965
  byte   PEGJL00 966-967
  byte   PEGAU00 968-969
  byte   PEGSE00 970-971
  byte   PEGOC00 972-973
  byte   PEGNO00 974-975
  byte   PEGDE00 976-977
  byte   PDKJA00 978-979
  byte   PDKFE00 980-981
  byte   PDKMA00 982-983
  byte   PDKAP00 984-985
  byte   PDKMY00 986-987
  byte   PDKJU00 988-989
  byte   PDKJL00 990-991
  byte   PDKAU00 992-993
  byte   PDKSE00 994-995
  byte   PDKOC00 996-997
  byte   PDKNO00 998-999
  byte   PDKDE00 1000-1001
  byte   PNGJA00 1002-1003
  byte   PNGFE00 1004-1005
  byte   PNGMA00 1006-1007
  byte   PNGAP00 1008-1009
  byte   PNGMY00 1010-1011
  byte   PNGJU00 1012-1013
  byte   PNGJL00 1014-1015
  byte   PNGAU00 1016-1017
  byte   PNGSE00 1018-1019
  byte   PNGOC00 1020-1021
  byte   PNGNO00 1022-1023
  byte   PNGDE00 1024-1025
  byte   POGJA00 1026-1027
  byte   POGFE00 1028-1029
  byte   POGMA00 1030-1031
  byte   POGAP00 1032-1033
  byte   POGMY00 1034-1035
  byte   POGJU00 1036-1037
  byte   POGJL00 1038-1039
  byte   POGAU00 1040-1041
  byte   POGSE00 1042-1043
  byte   POGOC00 1044-1045
  byte   POGNO00 1046-1047
  byte   POGDE00 1048-1049
  byte   PRSJA00 1050-1051
  byte   PRSFE00 1052-1053
  byte   PRSMA00 1054-1055
  byte   PRSAP00 1056-1057
  byte   PRSMY00 1058-1059
  byte   PRSJU00 1060-1061
  byte   PRSJL00 1062-1063
  byte   PRSAU00 1064-1065
  byte   PRSSE00 1066-1067
  byte   PRSOC00 1068-1069
  byte   PRSNO00 1070-1071
  byte   PRSDE00 1072-1073
  byte   POUJA00 1074-1075
  byte   POUFE00 1076-1077
  byte   POUMA00 1078-1079
  byte   POUAP00 1080-1081
  byte   POUMY00 1082-1083
  byte   POUJU00 1084-1085
  byte   POUJL00 1086-1087
  byte   POUAU00 1088-1089
  byte   POUSE00 1090-1091
  byte   POUOC00 1092-1093
  byte   POUNO00 1094-1095
  byte   POUDE00 1096-1097
  byte   PRIJA00 1098-1099
  byte   PRIFE00 1100-1101
  byte   PRIMA00 1102-1103
  byte   PRIAP00 1104-1105
  byte   PRIMY00 1106-1107
  byte   PRIJU00 1108-1109
  byte   PRIJL00 1110-1111
  byte   PRIAU00 1112-1113
  byte   PRISE00 1114-1115
  byte   PRIOC00 1116-1117
  byte   PRINO00 1118-1119
  byte   PRIDE00 1120-1121
  byte   HPEJA00 1122-1123
  byte   HPEFE00 1124-1125
  byte   HPEMA00 1126-1127
  byte   HPEAP00 1128-1129
  byte   HPEMY00 1130-1131
  byte   HPEJU00 1132-1133
  byte   HPEJL00 1134-1135
  byte   HPEAU00 1136-1137
  byte   HPESE00 1138-1139
  byte   HPEOC00 1140-1141
  byte   HPENO00 1142-1143
  byte   HPEDE00 1144-1145
  byte   HPDJA00 1146-1147
  byte   HPDFE00 1148-1149
  byte   HPDMA00 1150-1151
  byte   HPDAP00 1152-1153
  byte   HPDMY00 1154-1155
  byte   HPDJU00 1156-1157
  byte   HPDJL00 1158-1159
  byte   HPDAU00 1160-1161
  byte   HPDSE00 1162-1163
  byte   HPDOC00 1164-1165
  byte   HPDNO00 1166-1167
  byte   HPDDE00 1168-1169
  byte   HPNJA00 1170-1171
  byte   HPNFE00 1172-1173
  byte   HPNMA00 1174-1175
  byte   HPNAP00 1176-1177
  byte   HPNMY00 1178-1179
  byte   HPNJU00 1180-1181
  byte   HPNJL00 1182-1183
  byte   HPNAU00 1184-1185
  byte   HPNSE00 1186-1187
  byte   HPNOC00 1188-1189
  byte   HPNNO00 1190-1191
  byte   HPNDE00 1192-1193
  byte   HPOJA00 1194-1195
  byte   HPOFE00 1196-1197
  byte   HPOMA00 1198-1199
  byte   HPOAP00 1200-1201
  byte   HPOMY00 1202-1203
  byte   HPOJU00 1204-1205
  byte   HPOJL00 1206-1207
  byte   HPOAU00 1208-1209
  byte   HPOSE00 1210-1211
  byte   HPOOC00 1212-1213
  byte   HPONO00 1214-1215
  byte   HPODE00 1216-1217
  byte   HPSJA00 1218-1219
  byte   HPSFE00 1220-1221
  byte   HPSMA00 1222-1223
  byte   HPSAP00 1224-1225
  byte   HPSMY00 1226-1227
  byte   HPSJU00 1228-1229
  byte   HPSJL00 1230-1231
  byte   HPSAU00 1232-1233
  byte   HPSSE00 1234-1235
  byte   HPSOC00 1236-1237
  byte   HPSNO00 1238-1239
  byte   HPSDE00 1240-1241
  byte   HPRJA00 1242-1243
  byte   HPRFE00 1244-1245
  byte   HPRMA00 1246-1247
  byte   HPRAP00 1248-1249
  byte   HPRMY00 1250-1251
  byte   HPRJU00 1252-1253
  byte   HPRJL00 1254-1255
  byte   HPRAU00 1256-1257
  byte   HPRSE00 1258-1259
  byte   HPROC00 1260-1261
  byte   HPRNO00 1262-1263
  byte   HPRDE00 1264-1265
  byte   INSJA00X 1266-1267
  byte   INSFE00X 1268-1269
  byte   INSMA00X 1270-1271
  byte   INSAP00X 1272-1273
  byte   INSMY00X 1274-1275
  byte   INSJU00X 1276-1277
  byte   INSJL00X 1278-1279
  byte   INSAU00X 1280-1281
  byte   INSSE00X 1282-1283
  byte   INSOC00X 1284-1285
  byte   INSNO00X 1286-1287
  byte   INSDE00X 1288-1289
  byte   PRVEV00 1290-1290
  byte   TRIEV00 1291-1291
  byte   MCREV00 1292-1292
  byte   MCDEV00 1293-1293
  byte   OPAEV00 1294-1294
  byte   OPBEV00 1295-1295
  byte   UNINS00 1296-1296
  byte   INSCOV00 1297-1297
  byte   MCDHMO31 1298-1299
  byte   MCDHMO42 1300-1301
  byte   MCDHMO00 1302-1303
  byte   MCDMC31 1304-1305
  byte   MCDMC42 1306-1307
  byte   MCDMC00 1308-1309
  byte   PRVHMO31 1310-1311
  byte   PRVHMO42 1312-1313
  byte   PRVHMO00 1314-1315
  byte   PRVMNC31 1316-1317
  byte   PRVMNC42 1318-1319
  byte   PRVMNC00 1320-1321
  byte   PREVCOVR 1322-1323
  byte   COVRMM 1324-1325
  int    COVRYY 1326-1329
  byte   WASESTB 1330-1331
  byte   WASMCARE 1332-1333
  byte   WASMCAID 1334-1335
  byte   WASCHAMP 1336-1337
  byte   WASVA 1338-1339
  byte   WASPRIV 1340-1341
  byte   WASOTGOV 1342-1343
  byte   WASAFDC 1344-1345
  byte   WASSSI 1346-1347
  byte   WASSTAT1 1348-1349
  byte   WASSTAT2 1350-1351
  byte   WASOTHER 1352-1353
  byte   NOINSBEF 1354-1355
  byte   NOINSTM 1356-1357
  byte   NOINUNIT 1358-1359
  byte   MORECOVR 1360-1361
  byte   INSENDMM 1362-1363
  int    INSENDYY 1364-1367
  byte   DENYINSR 1368-1369
  byte   DNYCANC 1370-1371
  byte   DNYHYPER 1372-1373
  byte   DNYDIAB 1374-1375
  byte   DNYCORON 1376-1377
  byte   DENYOTH 1378-1379
  byte   INSLOOK 1380-1381
  byte   INSLIMIT 1382-1383
  byte   LMTBACK 1384-1385
  byte   LIMITOT 1386-1387
  byte   TRICR31X 1388-1389
  byte   TRICR42X 1390-1391
  byte   TRICR53X 1392-1393
  byte   TRICR00X 1394-1395
  byte   TRIAT31X 1396-1397
  byte   TRIAT42X 1398-1399
  byte   TRIAT53X 1400-1401
  byte   TRIAT00X 1402-1403
  byte   MCARE31 1404-1405
  byte   MCARE42 1406-1407
  byte   MCARE53 1408-1409
  byte   MCARE00 1410-1411
  byte   MCARE31X 1412-1413
  byte   MCARE42X 1414-1415
  byte   MCARE53X 1416-1417
  byte   MCARE00X 1418-1419
  byte   MCAID31 1420-1421
  byte   MCAID42 1422-1423
  byte   MCAID53 1424-1425
  byte   MCAID00 1426-1427
  byte   MCAID31X 1428-1429
  byte   MCAID42X 1430-1431
  byte   MCAID53X 1432-1433
  byte   MCAID00X 1434-1435
  byte   MCDAT31X 1436-1437
  byte   MCDAT42X 1438-1439
  byte   MCDAT53X 1440-1441
  byte   MCDAT00X 1442-1443
  byte   OTPUBA31 1444-1445
  byte   OTPUBA42 1446-1447
  byte   OTPUBA53 1448-1449
  byte   OTPUBA00 1450-1451
  byte   OTPAAT31 1452-1453
  byte   OTPAAT42 1454-1455
  byte   OTPAAT53 1456-1457
  byte   OTPAAT00 1458-1459
  byte   OTPUBB31 1460-1461
  byte   OTPUBB42 1462-1463
  byte   OTPUBB53 1464-1465
  byte   OTPUBB00 1466-1467
  byte   OTPBAT31 1468-1469
  byte   OTPBAT42 1470-1471
  byte   OTPBAT53 1472-1473
  byte   OTPBAT00 1474-1475
  byte   PUB31X 1476-1477
  byte   PUB42X 1478-1479
  byte   PUB53X 1480-1481
  byte   PUB00X 1482-1483
  byte   PUBAT31X 1484-1485
  byte   PUBAT42X 1486-1487
  byte   PUBAT53X 1488-1489
  byte   PUBAT00X 1490-1491
  byte   STAPR31 1492-1493
  byte   STAPR42 1494-1495
  byte   STAPR53 1496-1497
  byte   STAPR00 1498-1499
  byte   STPRAT31 1500-1501
  byte   STPRAT42 1502-1503
  byte   STPRAT53 1504-1505
  byte   STPRAT00 1506-1507
  byte   PRIEU31 1508-1509
  byte   PRIEU42 1510-1511
  byte   PRIEU53 1512-1513
  byte   PRIEU00 1514-1515
  byte   PRING31 1516-1517
  byte   PRING42 1518-1519
  byte   PRING53 1520-1521
  byte   PRING00 1522-1523
  byte   PRIOG31 1524-1525
  byte   PRIOG42 1526-1527
  byte   PRIOG53 1528-1529
  byte   PRIOG00 1530-1531
  byte   PRIDK31 1532-1533
  byte   PRIDK42 1534-1535
  byte   PRIDK53 1536-1537
  byte   PRIDK00 1538-1539
  byte   PRIS31 1540-1541
  byte   PRIS42 1542-1543
  byte   PRIS53 1544-1545
  byte   PRIS00 1546-1547
  byte   PROUT31 1548-1549
  byte   PROUT42 1550-1551
  byte   PROUT53 1552-1553
  byte   PROUT00 1554-1555
  byte   PRIV31 1556-1557
  byte   PRIV42 1558-1559
  byte   PRIV53 1560-1561
  byte   PRIV00 1562-1563
  byte   PRIVAT31 1564-1565
  byte   PRIVAT42 1566-1567
  byte   PRIVAT53 1568-1569
  byte   PRIVAT00 1570-1571
  byte   INS31X 1572-1573
  byte   INS42X 1574-1575
  byte   INS53X 1576-1577
  byte   INS00X 1578-1579
  byte   INSAT31X 1580-1581
  byte   INSAT42X 1582-1583
  byte   INSAT53X 1584-1585
  byte   INSAT00X 1586-1587
  byte   DENTIN31 1588-1589
  byte   DENTIN42 1590-1591
  byte   DENTIN53 1592-1593
  byte   PMEDIN31 1594-1595
  byte   PMEDIN42 1596-1597
  byte   PMEDIN53 1598-1599
  int    DDNWRK31 1600-1602
  int    DDNWRK42 1603-1605
  int    DDNWRK53 1606-1608
  int    WKINBD31 1609-1611
  int    WKINBD42 1612-1614
  int    WKINBD53 1615-1617
  int    DDNSCL31 1618-1620
  byte   DDNSCL42 1621-1622
  byte   DDNSCL53 1623-1624
  byte   SCLNBD31 1625-1626
  byte   SCLNBD42 1627-1628
  byte   SCLNBD53 1629-1630
  int    DDBDYS31 1631-1633
  int    DDBDYS42 1634-1636
  int    DDBDYS53 1637-1639
  byte   OTHDYS31 1640-1641
  byte   OTHDYS42 1642-1643
  byte   OTHDYS53 1644-1645
  int    OTHNDD31 1646-1648
  int    OTHNDD42 1649-1651
  int    OTHNDD53 1652-1654
  byte   ACCELI42 1655-1656
  byte   HAVEUS42 1657-1658
  byte   YNOUSC42 1659-1660
  byte   NOREAS42 1661-1662
  byte   SELDSI42 1663-1664
  byte   NEWARE42 1665-1666
  byte   DKWHRU42 1667-1668
  byte   USCNOT42 1669-1670
  byte   PERSLA42 1671-1672
  byte   DIFFPL42 1673-1674
  byte   INSRPL42 1675-1676
  byte   MYSELF42 1677-1678
  byte   CARECO42 1679-1680
  byte   OTHINS42 1681-1682
  byte   OTHREA42 1683-1684
  byte   TYPEPL42 1685-1686
  byte   PROVTY42 1687-1688
  byte   YGOTOU42 1689-1690
  byte   NOREA942 1691-1692
  byte   LIKESU42 1693-1694
  byte   DKELSE42 1695-1696
  byte   AFFORD42 1697-1698
  byte   OFFICE42 1699-1700
  byte   AVAILT42 1701-1702
  byte   CONVEN42 1703-1704
  byte   BSTPLA42 1705-1706
  byte   INSREA42 1707-1708
  byte   OTHRE942 1709-1710
  byte   GETTOU42 1711-1712
  byte   TYPEPE42 1713-1714
  byte   LOCATI42 1715-1716
  byte   MINORP42 1717-1718
  byte   PREVEN42 1719-1720
  byte   REFFRL42 1721-1722
  byte   OFFHOU42 1723-1724
  byte   APPTWL42 1725-1726
  byte   APPDIF42 1727-1728
  byte   WAITTI42 1729-1730
  byte   PHONED42 1731-1732
  byte   PRLIST42 1733-1734
  byte   TREATM42 1735-1736
  byte   CONFID42 1737-1738
  byte   PROVST42 1739-1740
  byte   USCQUA42 1741-1742
  byte   CHNGUS42 1743-1744
  byte   YCHNGU42 1745-1746
  byte   ANYUSC42 1747-1748
  byte   YNOMOR42 1749-1750
  byte   NOCARE42 1751-1752
  byte   HCNEED42 1753-1754
  byte   OBTAIN42 1755-1756
  byte   MAINPR42 1757-1758
  byte   NOOTHP42 1759-1760
  byte   NOAFFO42 1761-1762
  byte   INSNOP42 1763-1764
  byte   PREEXC42 1765-1766
  byte   INSRQR42 1767-1768
  byte   REFUSI42 1769-1770
  byte   DISTAN42 1771-1772
  byte   PUBTRA42 1773-1774
  byte   EXPENS42 1775-1776
  byte   HEARPR42 1777-1778
  byte   LANGBA42 1779-1780
  byte   INTOBL42 1781-1782
  byte   INSIDE42 1783-1784
  byte   EQUIPM42 1785-1786
  byte   OFFWOR42 1787-1788
  byte   DKWHER42 1789-1790
  byte   REFUSE42 1791-1792
  byte   CHLDCA42 1793-1794
  byte   NOTIME42 1795-1796
  byte   OTHRPR42 1797-1798
  byte   RTHLTH31 1799-1800
  byte   RTHLTH42 1801-1802
  byte   RTHLTH53 1803-1804
  byte   RTPROX31 1805-1806
  byte   RTPROX42 1807-1808
  byte   RTPROX53 1809-1810
  byte   MNHLTH31 1811-1812
  byte   MNHLTH42 1813-1814
  byte   MNHLTH53 1815-1816
  byte   MNPROX31 1817-1818
  byte   MNPROX42 1819-1820
  byte   MNPROX53 1821-1822
  byte   IADLHP31 1823-1824
  byte   IADLHP42 1825-1826
  byte   IADLHP53 1827-1828
  byte   ADLHLP31 1829-1830
  byte   ADLHLP42 1831-1832
  byte   ADLHLP53 1833-1834
  byte   AIDHLP31 1835-1836
  byte   AIDHLP53 1837-1838
  byte   WLKLIM31 1839-1840
  byte   WLKLIM53 1841-1842
  byte   LFTDIF31 1843-1844
  byte   LFTDIF53 1845-1846
  byte   STPDIF31 1847-1848
  byte   STPDIF53 1849-1850
  byte   WLKDIF31 1851-1852
  byte   WLKDIF53 1853-1854
  byte   MILDIF31 1855-1856
  byte   MILDIF53 1857-1858
  byte   STNDIF31 1859-1860
  byte   STNDIF53 1861-1862
  byte   BENDIF31 1863-1864
  byte   BENDIF53 1865-1866
  byte   RCHDIF31 1867-1868
  byte   RCHDIF53 1869-1870
  byte   FNGRDF31 1871-1872
  byte   FNGRDF53 1873-1874
  byte   ACTLIM31 1875-1876
  byte   ACTLIM53 1877-1878
  byte   WRKLIM31 1879-1880
  byte   WRKLIM53 1881-1882
  byte   HSELIM31 1883-1884
  byte   HSELIM53 1885-1886
  byte   SCHLIM31 1887-1888
  byte   SCHLIM53 1889-1890
  byte   UNABLE31 1891-1892
  byte   UNABLE53 1893-1894
  byte   SOCLIM31 1895-1896
  byte   SOCLIM53 1897-1898
  byte   COGLIM31 1899-1900
  byte   COGLIM53 1901-1902
  byte   WRGLAS42 1903-1904
  byte   SEEDIF42 1905-1906
  byte   BLIND42 1907-1908
  byte   READNW42 1909-1910
  byte   RECPEP42 1911-1912
  byte   VISION42 1913-1914
  byte   HEARAD42 1915-1916
  byte   HEARDI42 1917-1918
  byte   DEAF42 1919-1920
  byte   HEARMO42 1921-1922
  byte   HEARSM42 1923-1924
  byte   HEARNG42 1925-1926
  byte   ANYLIM00 1927-1928
  byte   LIMACT42 1929-1930
  byte   PLYLIM42 1931-1932
  byte   CANTPL42 1933-1934
  byte   SPCPRO42 1935-1936
  byte   DPTSHT42 1937-1938
  byte   NUMDPT42 1939-1940
  byte   POLSHT42 1941-1942
  byte   NUMPOL42 1943-1944
  byte   MMRSHT42 1945-1946
  byte   HEPSHT42 1947-1948
  byte   MOMPRO42 1949-1950
  byte   DADPRO42 1951-1952
  byte   UNHAP42 1953-1954
  byte   SCHLBH42 1955-1956
  byte   HAVFUN42 1957-1958
  byte   ADUPRO42 1959-1960
  byte   NERVAF42 1961-1962
  byte   SIBPRO42 1963-1964
  byte   KIDPRO42 1965-1966
  byte   SPRPRO42 1967-1968
  byte   SCHPRO42 1969-1970
  byte   HOMEBH42 1971-1972
  byte   TRBLE42 1973-1974
  byte   SPCSCH42 1975-1976
  byte   SPECED42 1977-1978
  byte   SPCHTH42 1979-1980
  byte   PSYCNS42 1981-1982
  byte   OCUPTH42 1983-1984
  byte   VOCSVC42 1985-1986
  byte   TUTOR42 1987-1988
  byte   READIN42 1989-1990
  byte   PHYTHR42 1991-1992
  byte   LIFSKL42 1993-1994
  byte   FAMCNS42 1995-1996
  byte   RECTHR42 1997-1998
  byte   OTHSVC42 1999-2000
  byte   CANTSC42 2001-2002
  byte   LMOACT42 2003-2004
  byte   HLTHY42 2005-2006
  byte   NTHLTH42 2007-2008
  byte   GETSIC42 2009-2010
  byte   HGTFT42 2011-2012
  byte   HGTIN42 2013-2014
  int    WGTLB42 2015-2017
  byte   WGTOZ42 2018-2019
  byte   CHLIM42 2020-2021
  byte   WHRCAR00 2022-2023
  byte   WHOCAR00 2024-2025
  byte   DAYCAR00 2026-2027
  byte   DENTCK53 2028-2029
  byte   CHOLCK53 2030-2031
  byte   CHECK53 2032-2033
  byte   FLUSHT53 2034-2035
  byte   LSTETH53 2036-2037
  byte   PSA53 2038-2039
  byte   HYSTER53 2040-2041
  byte   PAPSMR53 2042-2043
  byte   BRSTEX53 2044-2045
  byte   MAMOGR53 2046-2047
  byte   STOOL53 2048-2049
  byte   WHENST53 2050-2051
  byte   BOWEL53 2052-2053
  byte   WHNBWL53 2054-2055
  byte   PHYACT53 2056-2057
  byte   HGHTFT53 2058-2059
  byte   HGHTIN53 2060-2061
  int    WEIGHT53 2062-2064
  byte   WGTEST53 2065-2066
  byte   SEATBE53 2067-2068
  byte   DIABDX53 2069-2070
  byte   ASTHDX53 2071-2072
  byte   ASATAK53 2073-2074
  byte   ASMED53 2075-2076
  byte   ASSTER53 2077-2078
  byte   ASFLOW53 2079-2080
  byte   HIBPDX53 2081-2082
  byte   BPMLDX53 2083-2084
  byte   BPCHEK53 2085-2086
  byte   BPMONT53 2087-2088
  byte   CHDDX53 2089-2090
  byte   ANGIDX53 2091-2092
  byte   MIDX53 2093-2094
  byte   OHRTDX53 2095-2096
  byte   STRKDX53 2097-2098
  byte   EMPHDX53 2099-2100
  byte   NOFAT53 2101-2102
  byte   EXRCIS53 2103-2104
  byte   ASPRIN53 2105-2106
  byte   NOASPR53 2107-2108
  byte   STOMCH53 2109-2110
  byte   JTPAIN53 2111-2112
  byte   AGEJUL01 2113-2114
  byte   SVERLANG 2115-2116
  int    ADPRX42 2117-2119
  byte   ADRTCR42 2120-2121
  byte   ADRTWW42 2122-2123
  byte   ADILCR42 2124-2125
  byte   ADILWW42 2126-2127
  byte   ADAPPT42 2128-2129
  byte   ADNECR42 2130-2131
  byte   ADLIST42 2132-2133
  byte   ADEXPL42 2134-2135
  byte   ADRESP42 2136-2137
  byte   ADPRTM42 2138-2139
  byte   ADHECR42 2140-2141
  byte   ADDRBP42 2142-2143
  byte   ADSMOK42 2144-2145
  byte   ADDSMK42 2146-2147
  byte   ADSPEC42 2148-2149
  byte   ADPRRE42 2150-2151
  byte   ADGENH42 2152-2153
  byte   ADDAYA42 2154-2155
  byte   ADCLIM42 2156-2157
  byte   ADPACC42 2158-2159
  byte   ADPLMT42 2160-2161
  double PCS42 2162-2166
  byte   ADMACC42 2167-2168
  byte   ADMLMT42 2169-2170
  double MCS42 2171-2175
  byte   SFFLAG42 2176-2176
  byte   ADPAIN42 2177-2178
  byte   ADCALM42 2179-2180
  byte   ADPEP42 2181-2182
  byte   ADBLUE42 2183-2184
  byte   ADSOCA42 2185-2186
  byte   ADINSA42 2187-2188
  byte   ADINSB42 2189-2190
  byte   ADRISK42 2191-2192
  byte   ADOVER42 2193-2194
  byte   ADMOBI42 2195-2196
  byte   ADSELF42 2197-2198
  byte   ADACTI42 2199-2200
  byte   ADPAYN42 2201-2202
  byte   ADDEPR42 2203-2204
  byte   ADHLTH42 2205-2206
  int    ADSCAL42 2207-2209
  double EQU42 2210-2214
  byte   CHPRX42 2215-2216
  byte   CHRTCR42 2217-2218
  byte   CHRTWW42 2219-2220
  byte   CHILCR42 2221-2222
  byte   CHILWW42 2223-2224
  byte   CHAPPT42 2225-2226
  byte   CHNECR42 2227-2228
  byte   CHLIST42 2229-2230
  byte   CHEXPL42 2231-2232
  byte   CHRESP42 2233-2234
  byte   CHPRTM42 2235-2236
  byte   CHHECR42 2237-2238
  byte   CHSPEC42 2239-2240
  byte   CHPRRE42 2241-2242
  byte   CHPMED42 2243-2244
  byte   CHPMHB42 2245-2246
  byte   CHPMCN42 2247-2248
  byte   CHSERV42 2249-2250
  byte   CHSRHB42 2251-2252
  byte   CHSRCN42 2253-2254
  byte   CHLIMI42 2255-2256
  byte   CHLIHB42 2257-2258
  byte   CHLICO42 2259-2260
  byte   CHTHER42 2261-2262
  byte   CHTHHB42 2263-2264
  byte   CHTHCO42 2265-2266
  byte   CHCOUN42 2267-2268
  byte   CHEMPB42 2269-2270
  byte   CSHCN42 2271-2272
  byte   DSDIA53 2273-2274
  int    DSA1C53 2275-2277
  byte   DSCKFT53 2278-2279
  byte   DSEYE53 2280-2281
  byte   DSKIDN53 2282-2283
  byte   DSEYPR53 2284-2285
  byte   DSDIET53 2286-2287
  byte   DSMED53 2288-2289
  byte   DSINSU53 2290-2291
  byte   DSPRX53 2292-2293
  long   TOTTCH00 2294-2299
  long   TOTEXP00 2300-2305
  long   TOTSLF00 2306-2310
  long   TOTMCR00 2311-2316
  long   TOTMCD00 2317-2322
  long   TOTPRV00 2323-2328
  long   TOTVA00 2329-2334
  long   TOTTRI00 2335-2339
  long   TOTOFD00 2340-2344
  long   TOTSTL00 2345-2349
  long   TOTWCP00 2350-2354
  long   TOTOPR00 2355-2359
  long   TOTOPU00 2360-2364
  long   TOTOSR00 2365-2369
  int    OBTOTV00 2370-2372
  long   OBVTCH00 2373-2377
  long   OBVEXP00 2378-2382
  long   OBVSLF00 2383-2387
  long   OBVMCR00 2388-2392
  long   OBVMCD00 2393-2397
  long   OBVPRV00 2398-2402
  long   OBVVA00 2403-2407
  long   OBVTRI00 2408-2412
  int    OBVOFD00 2413-2416
  int    OBVSTL00 2417-2420
  long   OBVWCP00 2421-2425
  int    OBVOPR00 2426-2429
  long   OBVOPU00 2430-2434
  long   OBVOSR00 2435-2439
  int    OBDRV00 2440-2442
  long   OBDTCH00 2443-2447
  long   OBDEXP00 2448-2452
  long   OBDSLF00 2453-2457
  long   OBDMCR00 2458-2462
  long   OBDMCD00 2463-2467
  long   OBDPRV00 2468-2472
  long   OBDVA00 2473-2477
  long   OBDTRI00 2478-2482
  int    OBDOFD00 2483-2486
  int    OBDSTL00 2487-2490
  long   OBDWCP00 2491-2495
  int    OBDOPR00 2496-2499
  int    OBDOPU00 2500-2503
  long   OBDOSR00 2504-2508
  int    OBOTHV00 2509-2511
  long   OBOTCH00 2512-2516
  long   OBOEXP00 2517-2521
  int    OBOSLF00 2522-2525
  long   OBOMCR00 2526-2530
  long   OBOMCD00 2531-2535
  long   OBOPRV00 2536-2540
  int    OBOVA00 2541-2544
  int    OBOTRI00 2545-2547
  int    OBOOFD00 2548-2551
  int    OBOSTL00 2552-2555
  int    OBOWCP00 2556-2559
  int    OBOOPR00 2560-2563
  long   OBOOPU00 2564-2568
  int    OBOOSR00 2569-2572
  int    OBCHIR00 2573-2575
  long   OBCTCH00 2576-2580
  long   OBCEXP00 2581-2585
  int    OBCSLF00 2586-2589
  long   OBCMCR00 2590-2594
  int    OBCMCD00 2595-2598
  int    OBCPRV00 2599-2602
  int    OBCVA00 2603-2606
  int    OBCTRI00 2607-2609
  byte   OBCOFD00 2610-2610
  int    OBCSTL00 2611-2613
  int    OBCWCP00 2614-2617
  int    OBCOPR00 2618-2620
  byte   OBCOPU00 2621-2621
  int    OBCOSR00 2622-2625
  byte   OBNURS00 2626-2627
  long   OBNTCH00 2628-2632
  long   OBNEXP00 2633-2637
  int    OBNSLF00 2638-2641
  long   OBNMCR00 2642-2646
  int    OBNMCD00 2647-2650
  long   OBNPRV00 2651-2655
  int    OBNVA00 2656-2659
  int    OBNTRI00 2660-2662
  int    OBNOFD00 2663-2666
  int    OBNSTL00 2667-2670
  int    OBNWCP00 2671-2673
  int    OBNOPR00 2674-2677
  int    OBNOPU00 2678-2681
  int    OBNOSR00 2682-2685
  byte   OBOPTO00 2686-2687
  int    OBETCH00 2688-2691
  int    OBEEXP00 2692-2694
  int    OBESLF00 2695-2697
  int    OBEMCR00 2698-2700
  int    OBEMCD00 2701-2703
  int    OBEPRV00 2704-2706
  byte   OBEVA00 2707-2708
  int    OBETRI00 2709-2711
  int    OBEOFD00 2712-2714
  int    OBESTL00 2715-2717
  byte   OBEWCP00 2718-2719
  int    OBEOPR00 2720-2722
  int    OBEOPU00 2723-2725
  int    OBEOSR00 2726-2728
  byte   OBASST00 2729-2730
  int    OBATCH00 2731-2734
  int    OBAEXP00 2735-2738
  int    OBASLF00 2739-2741
  int    OBAMCR00 2742-2744
  int    OBAMCD00 2745-2748
  int    OBAPRV00 2749-2752
  int    OBAVA00 2753-2756
  int    OBATRI00 2757-2759
  int    OBAOFD00 2760-2763
  byte   OBASTL00 2764-2765
  int    OBAWCP00 2766-2768
  int    OBAOPR00 2769-2771
  byte   OBAOPU00 2772-2773
  byte   OBAOSR00 2774-2775
  int    OBTHER00 2776-2778
  long   OBTTCH00 2779-2783
  long   OBTEXP00 2784-2788
  int    OBTSLF00 2789-2792
  long   OBTMCR00 2793-2797
  int    OBTMCD00 2798-2801
  int    OBTPRV00 2802-2805
  int    OBTVA00 2806-2809
  int    OBTTRI00 2810-2812
  int    OBTOFD00 2813-2815
  int    OBTSTL00 2816-2819
  int    OBTWCP00 2820-2823
  int    OBTOPR00 2824-2827
  byte   OBTOPU00 2828-2829
  int    OBTOSR00 2830-2833
  int    OPTOTV00 2834-2836
  long   OPFTCH00 2837-2842
  long   OPFEXP00 2843-2847
  long   OPFSLF00 2848-2852
  long   OPFMCR00 2853-2857
  long   OPFMCD00 2858-2862
  long   OPFPRV00 2863-2867
  long   OPFVA00 2868-2872
  int    OPFTRI00 2873-2876
  long   OPFOFD00 2877-2881
  long   OPFSTL00 2882-2886
  long   OPFWCP00 2887-2891
  int    OPFOPR00 2892-2895
  int    OPFOPU00 2896-2899
  long   OPFOSR00 2900-2904
  long   OPDEXP00 2905-2909
  long   OPDTCH00 2910-2914
  int    OPDSLF00 2915-2918
  int    OPDMCR00 2919-2922
  int    OPDMCD00 2923-2926
  int    OPDPRV00 2927-2930
  int    OPDVA00 2931-2933
  int    OPDTRI00 2934-2937
  byte   OPDOFD00 2938-2938
  int    OPDSTL00 2939-2941
  long   OPDWCP00 2942-2946
  int    OPDOPR00 2947-2950
  int    OPDOPU00 2951-2954
  byte   OPDOSR00 2955-2955
  int    OPDRV00 2956-2958
  long   OPVTCH00 2959-2964
  long   OPVEXP00 2965-2969
  long   OPVSLF00 2970-2974
  long   OPVMCR00 2975-2979
  long   OPVMCD00 2980-2984
  long   OPVPRV00 2985-2989
  long   OPVVA00 2990-2994
  int    OPVTRI00 2995-2998
  int    OPVOFD00 2999-3002
  int    OPVSTL00 3003-3006
  long   OPVWCP00 3007-3011
  int    OPVOPR00 3012-3015
  int    OPVOPU00 3016-3019
  long   OPVOSR00 3020-3024
  long   OPSEXP00 3025-3029
  long   OPSTCH00 3030-3034
  int    OPSSLF00 3035-3038
  int    OPSMCR00 3039-3042
  int    OPSMCD00 3043-3046
  int    OPSPRV00 3047-3050
  int    OPSVA00 3051-3053
  int    OPSTRI00 3054-3057
  byte   OPSOFD00 3058-3058
  int    OPSSTL00 3059-3061
  long   OPSWCP00 3062-3066
  int    OPSOPR00 3067-3070
  int    OPSOPU00 3071-3073
  byte   OPSOSR00 3074-3074
  int    OPOTHV00 3075-3077
  long   OPOTCH00 3078-3083
  long   OPOEXP00 3084-3088
  int    OPOSLF00 3089-3092
  long   OPOMCR00 3093-3097
  long   OPOMCD00 3098-3102
  long   OPOPRV00 3103-3107
  long   OPOVA00 3108-3112
  int    OPOTRI00 3113-3116
  long   OPOOFD00 3117-3121
  int    OPOSTL00 3122-3125
  int    OPOWCP00 3126-3129
  int    OPOOPR00 3130-3133
  int    OPOOPU00 3134-3137
  int    OPOOSR00 3138-3141
  int    OPPEXP00 3142-3145
  long   OPPTCH00 3146-3150
  int    OPPSLF00 3151-3153
  int    OPPMCR00 3154-3157
  int    OPPMCD00 3158-3160
  int    OPPPRV00 3161-3164
  int    OPPVA00 3165-3167
  byte   OPPTRI00 3168-3169
  byte   OPPOFD00 3170-3170
  int    OPPSTL00 3171-3173
  int    OPPWCP00 3174-3176
  int    OPPOPR00 3177-3180
  int    OPPOPU00 3181-3184
  byte   OPPOSR00 3185-3185
  int    AMCHIR00 3186-3188
  long   AMCTCH00 3189-3193
  long   AMCEXP00 3194-3198
  int    AMCSLF00 3199-3202
  long   AMCMCR00 3203-3207
  int    AMCMCD00 3208-3211
  int    AMCPRV00 3212-3215
  int    AMCVA00 3216-3219
  int    AMCTRI00 3220-3222
  byte   AMCOFD00 3223-3223
  int    AMCSTL00 3224-3226
  int    AMCWCP00 3227-3230
  int    AMCOPR00 3231-3233
  byte   AMCOPU00 3234-3234
  int    AMCOSR00 3235-3238
  byte   AMNURS00 3239-3240
  long   AMNTCH00 3241-3245
  long   AMNEXP00 3246-3250
  int    AMNSLF00 3251-3254
  long   AMNMCR00 3255-3259
  long   AMNMCD00 3260-3264
  long   AMNPRV00 3265-3269
  int    AMNVA00 3270-3273
  int    AMNTRI00 3274-3276
  int    AMNOFD00 3277-3280
  int    AMNSTL00 3281-3284
  int    AMNWCP00 3285-3287
  int    AMNOPR00 3288-3291
  int    AMNOPU00 3292-3295
  int    AMNOSR00 3296-3299
  byte   AMOPTO00 3300-3301
  int    AMETCH00 3302-3305
  int    AMEEXP00 3306-3309
  int    AMESLF00 3310-3313
  int    AMEMCR00 3314-3316
  int    AMEMCD00 3317-3319
  int    AMEPRV00 3320-3323
  int    AMEVA00 3324-3326
  int    AMETRI00 3327-3329
  int    AMEOFD00 3330-3332
  int    AMESTL00 3333-3335
  byte   AMEWCP00 3336-3337
  int    AMEOPR00 3338-3340
  int    AMEOPU00 3341-3343
  int    AMEOSR00 3344-3346
  byte   AMASST00 3347-3348
  int    AMATCH00 3349-3352
  int    AMAEXP00 3353-3356
  int    AMASLF00 3357-3359
  int    AMAMCR00 3360-3362
  int    AMAMCD00 3363-3366
  int    AMAPRV00 3367-3370
  int    AMAVA00 3371-3374
  int    AMATRI00 3375-3377
  int    AMAOFD00 3378-3381
  byte   AMASTL00 3382-3383
  int    AMAWCP00 3384-3386
  int    AMAOPR00 3387-3389
  byte   AMAOPU00 3390-3391
  byte   AMAOSR00 3392-3393
  int    AMTHER00 3394-3396
  long   AMTTCH00 3397-3402
  long   AMTEXP00 3403-3407
  int    AMTSLF00 3408-3411
  long   AMTMCR00 3412-3416
  int    AMTMCD00 3417-3420
  int    AMTPRV00 3421-3424
  int    AMTVA00 3425-3428
  int    AMTTRI00 3429-3431
  int    AMTOFD00 3432-3434
  int    AMTSTL00 3435-3438
  int    AMTWCP00 3439-3442
  int    AMTOPR00 3443-3446
  byte   AMTOPU00 3447-3448
  int    AMTOSR00 3449-3452
  byte   AMTOTC00 3453-3454
  byte   AMDRC00 3455-3455
  byte   ERTOT00 3456-3457
  long   ERFTCH00 3458-3462
  long   ERFEXP00 3463-3467
  int    ERFSLF00 3468-3471
  int    ERFMCR00 3472-3475
  int    ERFMCD00 3476-3479
  long   ERFPRV00 3480-3484
  long   ERFVA00 3485-3489
  int    ERFTRI00 3490-3493
  int    ERFOFD00 3494-3497
  int    ERFSTL00 3498-3501
  int    ERFWCP00 3502-3505
  long   ERFOPR00 3506-3510
  int    ERFOPU00 3511-3514
  int    ERFOSR00 3515-3518
  int    ERDEXP00 3519-3522
  int    ERDTCH00 3523-3526
  int    ERDSLF00 3527-3530
  int    ERDMCR00 3531-3534
  int    ERDMCD00 3535-3537
  int    ERDPRV00 3538-3541
  int    ERDVA00 3542-3544
  int    ERDTRI00 3545-3547
  int    ERDOFD00 3548-3550
  int    ERDSTL00 3551-3553
  int    ERDWCP00 3554-3556
  int    ERDOPR00 3557-3559
  int    ERDOPU00 3560-3562
  int    ERDOSR00 3563-3565
  byte   IPZERO00 3566-3566
  long   ZIFTCH00 3567-3571
  long   ZIFEXP00 3572-3576
  int    ZIFSLF00 3577-3580
  long   ZIFMCR00 3581-3585
  int    ZIFMCD00 3586-3589
  long   ZIFPRV00 3590-3594
  int    ZIFVA00 3595-3598
  int    ZIFTRI00 3599-3602
  int    ZIFOFD00 3603-3606
  int    ZIFSTL00 3607-3609
  int    ZIFWCP00 3610-3613
  int    ZIFOPR00 3614-3617
  int    ZIFOPU00 3618-3621
  byte   ZIFOSR00 3622-3622
  int    ZIDEXP00 3623-3626
  long   ZIDTCH00 3627-3631
  int    ZIDSLF00 3632-3634
  int    ZIDMCR00 3635-3638
  int    ZIDMCD00 3639-3642
  int    ZIDPRV00 3643-3646
  int    ZIDVA00 3647-3650
  int    ZIDTRI00 3651-3653
  byte   ZIDOFD00 3654-3654
  byte   ZIDSTL00 3655-3655
  int    ZIDWCP00 3656-3659
  int    ZIDOPR00 3660-3663
  int    ZIDOPU00 3664-3667
  byte   ZIDOSR00 3668-3668
  byte   IPDIS00 3669-3670
  long   IPFEXP00 3671-3676
  long   IPFTCH00 3677-3682
  long   IPFSLF00 3683-3687
  long   IPFMCR00 3688-3693
  long   IPFMCD00 3694-3699
  long   IPFPRV00 3700-3705
  long   IPFVA00 3706-3711
  int    IPFTRI00 3712-3715
  int    IPFOFD00 3716-3719
  long   IPFSTL00 3720-3724
  long   IPFWCP00 3725-3729
  long   IPFOPR00 3730-3734
  long   IPFOPU00 3735-3739
  int    IPFOSR00 3740-3743
  long   IPDEXP00 3744-3748
  long   IPDTCH00 3749-3753
  int    IPDSLF00 3754-3757
  long   IPDMCR00 3758-3762
  long   IPDMCD00 3763-3767
  long   IPDPRV00 3768-3772
  int    IPDVA00 3773-3776
  int    IPDTRI00 3777-3780
  byte   IPDOFD00 3781-3781
  int    IPDSTL00 3782-3785
  long   IPDWCP00 3786-3790
  int    IPDOPR00 3791-3794
  int    IPDOPU00 3795-3798
  int    IPDOSR00 3799-3801
  int    IPNGTD00 3802-3804
  byte   DVTOT00 3805-3806
  long   DVTTCH00 3807-3811
  long   DVTEXP00 3812-3816
  long   DVTSLF00 3817-3821
  int    DVTMCR00 3822-3825
  int    DVTMCD00 3826-3829
  long   DVTPRV00 3830-3834
  int    DVTVA00 3835-3838
  int    DVTTRI00 3839-3842
  int    DVTOFD00 3843-3846
  int    DVTSTL00 3847-3850
  int    DVTWCP00 3851-3854
  int    DVTOPR00 3855-3858
  int    DVTOPU00 3859-3862
  int    DVTOSR00 3863-3866
  byte   DVGEN00 3867-3868
  long   DVGTCH00 3869-3873
  long   DVGEXP00 3874-3878
  int    DVGSLF00 3879-3882
  int    DVGMCR00 3883-3886
  int    DVGMCD00 3887-3890
  int    DVGPRV00 3891-3894
  int    DVGVA00 3895-3898
  int    DVGTRI00 3899-3902
  int    DVGOFD00 3903-3906
  int    DVGSTL00 3907-3910
  int    DVGWCP00 3911-3914
  int    DVGOPR00 3915-3918
  int    DVGOPU00 3919-3922
  int    DVGOSR00 3923-3926
  byte   DVORTH00 3927-3928
  long   DVOTCH00 3929-3933
  long   DVOEXP00 3934-3938
  long   DVOSLF00 3939-3943
  int    DVOMCR00 3944-3946
  int    DVOMCD00 3947-3950
  long   DVOPRV00 3951-3955
  int    DVOVA00 3956-3958
  int    DVOTRI00 3959-3962
  int    DVOOFD00 3963-3965
  byte   DVOSTL00 3966-3967
  byte   DVOWCP00 3968-3968
  int    DVOOPR00 3969-3972
  byte   DVOOPU00 3973-3974
  int    DVOOSR00 3975-3978
  int    HHTOTD00 3979-3981
  int    HHAGD00 3982-3984
  long   HHATCH00 3985-3990
  long   HHAEXP00 3991-3996
  int    HHASLF00 3997-4000
  long   HHAMCR00 4001-4005
  long   HHAMCD00 4006-4011
  long   HHAPRV00 4012-4016
  long   HHAVA00 4017-4021
  int    HHATRI00 4022-4025
  long   HHAOFD00 4026-4030
  long   HHASTL00 4031-4035
  byte   HHAWCP00 4036-4036
  long   HHAOPR00 4037-4041
  int    HHAOPU00 4042-4045
  int    HHAOSR00 4046-4048
  int    HHINDD00 4049-4051
  long   HHNTCH00 4052-4056
  long   HHNEXP00 4057-4061
  long   HHNSLF00 4062-4066
  int    HHNMCR00 4067-4069
  long   HHNMCD00 4070-4074
  long   HHNPRV00 4075-4079
  int    HHNVA00 4080-4083
  byte   HHNTRI00 4084-4084
  byte   HHNOFD00 4085-4085
  int    HHNSTL00 4086-4089
  byte   HHNWCP00 4090-4090
  byte   HHNOPR00 4091-4092
  byte   HHNOPU00 4093-4093
  byte   HHNOSR00 4094-4095
  int    HHINFD00 4096-4098
  int    VISEXP00 4099-4102
  int    VISTCH00 4103-4106
  int    VISSLF00 4107-4110
  int    VISMCR00 4111-4113
  int    VISMCD00 4114-4117
  int    VISPRV00 4118-4120
  int    VISVA00 4121-4123
  int    VISTRI00 4124-4126
  int    VISOFD00 4127-4129
  int    VISSTL00 4130-4132
  int    VISWCP00 4133-4135
  int    VISOPR00 4136-4138
  int    VISOPU00 4139-4141
  int    VISOSR00 4142-4144
  long   OTHTCH00 4145-4149
  long   OTHEXP00 4150-4154
  long   OTHSLF00 4155-4159
  int    OTHMCR00 4160-4163
  int    OTHMCD00 4164-4167
  int    OTHPRV00 4168-4171
  int    OTHVA00 4172-4175
  int    OTHTRI00 4176-4179
  int    OTHOFD00 4180-4182
  byte   OTHSTL00 4183-4184
  int    OTHWCP00 4185-4187
  int    OTHOPR00 4188-4190
  int    OTHOPU00 4191-4193
  int    OTHOSR00 4194-4196
  int    RXTOT00 4197-4199
  long   RXEXP00 4200-4204
  long   RXSLF00 4205-4209
  int    RXMCR00 4210-4213
  long   RXMCD00 4214-4218
  long   RXPRV00 4219-4223
  long   RXVA00 4224-4228
  int    RXTRI00 4229-4232
  int    RXOFD00 4233-4235
  int    RXSTL00 4236-4239
  int    RXWCP00 4240-4243
  int    RXOPR00 4244-4247
  int    RXOPU00 4248-4250
  int    RXOSR00 4251-4254
  double PERWT00F 4255-4266
  double FAMWT00F 4267-4278
  double FAMWT00C 4279-4290
  double SQPQW00F 4291-4302
  double DIABW00F 4303-4314
  byte   VARSTR00 4315-4316
  byte   VARPSU00 4317-4318
using H50.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL00 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID00 "FAMILY ID (STUDENT MERGED IN) - 12/31/00";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPS-LIKE FAMILY IDENTIFIER";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-00";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-00";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR00 "RU LETTER AS OF 12/31/00";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE00 "RU SIZE AS OF 12/31/00";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS00 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/00";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE00 "RU SIZE INCLUDING STUDENT AS OF 12/31/00";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION00 "CENSUS REGION AS OF 12/31/00";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA00 "MSA AS OF 12/31/00";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS00 "REFERENCE PERSON AS OF 12/31/00";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP00 "1ST RESPONDENT INDICATOR AS OF 12/31/00";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY00 "WAS RESPONDENT A PROXY AS OF 12/31/00";
label variable INTVLANG "LANGUAGE INTERVIEW WAS CONDUCTED IN";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD00 "2000 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM00 "2000 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY00 "2000 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP00 "INSCOPE - R5/3 START THROUGH 12/31/00";
label variable INSC1231 "INSCOPE STATUS ON 12/31/00";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2000";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND00 "ELIGIBILITY STATUS AS OF 12/31/00";
label variable ELIGIBLE "WAS PERSON EVER ELIGIBLE IN 2000";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE00X "AGE AS OF 12/31/00 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY00X "MARITAL STATUS-12/31/00 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID00 "SPOUSE ID - 12/31/00";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN00 "MARITAL STATUS W/SPOUSE PRESENT-12/31/00";
label variable EDUCYEAR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEGYR "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU00X "STUDENT STATUS IF AGES 17-23 - 12/31/00";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL00X "RELATION TO REF PERS-12/31/00 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS00 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC00 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR00 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL00 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT00 "PERSON S FILING STATUS";
label variable FILER00 "PRIMARY OR SECONDARY FILER";
label variable JTINRU00 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID00 "PID OF SECONDARY FILER";
label variable CLMDEP00 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT00 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU00 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD00 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM00 "TAX FORM PERSON WILL FILE";
label variable DEDUCT00 "ITEMIZE OR STANDARD DEDUCTION";
label variable ITMEXP00 "WILL PERSON ITEMIZE MEDICAL EXPENSE";
label variable MEXAMT00 "TOTAL AMOUNT FOR MEDICAL EXPENSES";
label variable NTMDED00 "PERSON S NET MEDICAL EXPENSE DEDUCTION";
label variable TOTDED00 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP00 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable ELDISC00 "DID/WILL PERS RECEIVE ELDERLY/DISAB CRED";
label variable EICRDT00 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable UNEMTX00 "TAXABLE PERCENTAGE OF UNEMPLOYMENT";
label variable INTRTX00 "TAXABLE PERCENTAGE OF INTEREST";
label variable SSECTX00 "TAXABLE PERCENTAGE OF SOCIAL SECURITY";
label variable IRATAX00 "TAXABLE PERCENTAGE OF IRA INCOME";
label variable FOODST00 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN00 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT00 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL00 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP00X "PERSON S TOTAL INCOME";
label variable POVCAT00 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP00X "PERSON S WAGE INCOME";
label variable WAGIMP00 "WAGE IMPUTATION FLAG";
label variable BUSNP00X "PERSON S BUSINESS INCOME";
label variable BUSIMP00 "BUSINESS INCOME IMPUTATION FLAG";
label variable FARMP00X "PERSON S FARM INCOME";
label variable FARIMP00 "FARM INCOME IMPUTATION FLAG";
label variable UNEMP00X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP00 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP00X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP00 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP00X "PERSON S INTEREST INCOME";
label variable INTIMP00 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP00X "PERSON S DIVIDEND INCOME";
label variable DIVIMP00 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP00X "PERSON S SALES INCOME";
label variable SALIMP00 "SALES INCOME IMPUTATION FLAG";
label variable PENSP00X "PERSON S PENSION INCOME";
label variable PENIMP00 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP00X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP00 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP00X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP00 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP00X "PERSON S VETERAN S INCOME";
label variable VETIMP00 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP00X "PERSON S IRA INCOME";
label variable IRAIMP00 "IRA INCOME IMPUTATION FLAG";
label variable REFDP00X "PERSON S REFUND INCOME";
label variable REFIMP00 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP00X "PERSON S ALIMONY INCOME";
label variable ALIIMP00 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP00X "PERSON S CHILD SUPPORT";
label variable CHLIMP00 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP00X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP00 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP00X "PERSON S SSI";
label variable SSIIMP00 "SSI IMPUTATION FLAG";
label variable PUBP00X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP00 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP00X "PERSON S OTHER INCOME";
label variable OTHIMP00 "OTHER INCOME IMPUTATION FLAG";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/00";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMPUTED)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMPUTED)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMPUTED)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable CIND31 "CONDENSED INDUSTRY CODE RD 3/1 CMJ";
label variable CIND42 "CONDENSED INDUSTRY CODE RD 4/2 CMJ";
label variable CIND53 "CONDENSED INDUSTRY CODE RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable COCCP31 "CONDENSED OCCUPATION CODE RD 3/1 CMJ";
label variable COCCP42 "CONDENSED OCCUPATION CODE RD 4/2 CMJ";
label variable COCCP53 "CONDENSED OCCUPATION CODE RD 5/3 CMJ";
label variable BGNWK31 "USUAL START TIME OF RD 3/1 CMJ";
label variable BGNWK42 "USUAL START TIME OF RD 4/2 CMJ";
label variable BGNWK53 "USUAL START TIME OF RD 5/3 CMJ";
label variable ENDWK31 "USUAL END TIME OF RD 3/1 CMJ";
label variable ENDWK42 "USUAL END TIME OF RD 4/2 CMJ";
label variable ENDWK53 "USUAL END TIME OF RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable SHFTWK31 "IRREGULAR WORK SHIFT RD 3/1 CMJ";
label variable SHFTWK42 "IRREGULAR WORK SHIFT RD 4/2 CMJ";
label variable SHFTWK53 "IRREGULAR WORK SHIFT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable TRIJA00X "COVERED BY TRICARE IN JAN00 (ED)";
label variable TRIFE00X "COVERED BY TRICARE IN FEB00 (ED)";
label variable TRIMA00X "COVERED BY TRICARE IN MAR00 (ED)";
label variable TRIAP00X "COVERED BY TRICARE IN APR00 (ED)";
label variable TRIMY00X "COVERED BY TRICARE IN MAY00 (ED)";
label variable TRIJU00X "COVERED BY TRICARE IN JUN00 (ED)";
label variable TRIJL00X "COVERED BY TRICARE IN JUL00 (ED)";
label variable TRIAU00X "COVERED BY TRICARE IN AUG00 (ED)";
label variable TRISE00X "COVERED BY TRICARE IN SEP00 (ED)";
label variable TRIOC00X "COVERED BY TRICARE IN OCT00 (ED)";
label variable TRINO00X "COVERED BY TRICARE IN NOV00 (ED)";
label variable TRIDE00X "COVERED BY TRICARE IN DEC00 (ED)";
label variable MCRJA00 "COVERED BY MEDICARE IN JAN00";
label variable MCRFE00 "COVERED BY MEDICARE IN FEB00";
label variable MCRMA00 "COVERED BY MEDICARE IN MAR00";
label variable MCRAP00 "COVERED BY MEDICARE IN APR00";
label variable MCRMY00 "COVERED BY MEDICARE IN MAY00";
label variable MCRJU00 "COVERED BY MEDICARE IN JUN00";
label variable MCRJL00 "COVERED BY MEDICARE IN JUL00";
label variable MCRAU00 "COVERED BY MEDICARE IN AUG00";
label variable MCRSE00 "COVERED BY MEDICARE IN SEP00";
label variable MCROC00 "COVERED BY MEDICARE IN OCT00";
label variable MCRNO00 "COVERED BY MEDICARE IN NOV00";
label variable MCRDE00 "COVERED BY MEDICARE IN DEC00";
label variable MCRJA00X "COVERED BY MEDICARE IN JAN00 (ED)";
label variable MCRFE00X "COVERED BY MEDICARE IN FEB00 (ED)";
label variable MCRMA00X "COVERED BY MEDICARE IN MAR00 (ED)";
label variable MCRAP00X "COVERED BY MEDICARE IN APR00 (ED)";
label variable MCRMY00X "COVERED BY MEDICARE IN MAY00 (ED)";
label variable MCRJU00X "COVERED BY MEDICARE IN JUN00 (ED)";
label variable MCRJL00X "COVERED BY MEDICARE IN JUL00 (ED)";
label variable MCRAU00X "COVERED BY MEDICARE IN AUG00 (ED)";
label variable MCRSE00X "COVERED BY MEDICARE IN SEP00 (ED)";
label variable MCROC00X "COVERED BY MEDICARE IN OCT00 (ED)";
label variable MCRNO00X "COVERED BY MEDICARE IN NOV00 (ED)";
label variable MCRDE00X "COVERED BY MEDICARE IN DEC00 (ED)";
label variable MCDJA00 "COVERED BY MEDICAID IN JAN00";
label variable MCDFE00 "COVERED BY MEDICAID IN FEB00";
label variable MCDMA00 "COVERED BY MEDICAID IN MAR00";
label variable MCDAP00 "COVERED BY MEDICAID IN APR00";
label variable MCDMY00 "COVERED BY MEDICAID IN MAY00";
label variable MCDJU00 "COVERED BY MEDICAID IN JUN00";
label variable MCDJL00 "COVERED BY MEDICAID IN JUL00";
label variable MCDAU00 "COVERED BY MEDICAID IN AUG00";
label variable MCDSE00 "COVERED BY MEDICAID IN SEP00";
label variable MCDOC00 "COVERED BY MEDICAID IN OCT00";
label variable MCDNO00 "COVERED BY MEDICAID IN NOV00";
label variable MCDDE00 "COVERED BY MEDICAID IN DEC00";
label variable MCDJA00X "COVERED BY MEDICAID IN JAN00 (ED)";
label variable MCDFE00X "COVERED BY MEDICAID IN FEB00 (ED)";
label variable MCDMA00X "COVERED BY MEDICAID IN MAR00 (ED)";
label variable MCDAP00X "COVERED BY MEDICAID IN APR00 (ED)";
label variable MCDMY00X "COVERED BY MEDICAID IN MAY00 (ED)";
label variable MCDJU00X "COVERED BY MEDICAID IN JUN00 (ED)";
label variable MCDJL00X "COVERED BY MEDICAID IN JUL00 (ED)";
label variable MCDAU00X "COVERED BY MEDICAID IN AUG00 (ED)";
label variable MCDSE00X "COVERED BY MEDICAID IN SEP00 (ED)";
label variable MCDOC00X "COVERED BY MEDICAID IN OCT00 (ED)";
label variable MCDNO00X "COVERED BY MEDICAID IN NOV00 (ED)";
label variable MCDDE00X "COVERED BY MEDICAID IN DEC00 (ED)";
label variable OPAJA00 "COV BY OTHER PUBLIC A INS IN JAN00";
label variable OPAFE00 "COV BY OTHER PUBLIC A INS IN FEB00";
label variable OPAMA00 "COV BY OTHER PUBLIC A INS IN MAR00";
label variable OPAAP00 "COV BY OTHER PUBLIC A INS IN APR00";
label variable OPAMY00 "COV BY OTHER PUBLIC A INS IN MAY00";
label variable OPAJU00 "COV BY OTHER PUBLIC A INS IN JUN00";
label variable OPAJL00 "COV BY OTHER PUBLIC A INS IN JUL00";
label variable OPAAU00 "COV BY OTHER PUBLIC A INS IN AUG00";
label variable OPASE00 "COV BY OTHER PUBLIC A INS IN SEP00";
label variable OPAOC00 "COV BY OTHER PUBLIC A INS IN OCT00";
label variable OPANO00 "COV BY OTHER PUBLIC A INS IN NOV00";
label variable OPADE00 "COV BY OTHER PUBLIC A INS IN DEC00";
label variable OPBJA00 "COV BY OTHER PUBLIC B INS IN JAN00";
label variable OPBFE00 "COV BY OTHER PUBLIC B INS IN FEB00";
label variable OPBMA00 "COV BY OTHER PUBLIC B INS IN MAR00";
label variable OPBAP00 "COV BY OTHER PUBLIC B INS IN APR00";
label variable OPBMY00 "COV BY OTHER PUBLIC B INS IN MAY00";
label variable OPBJU00 "COV BY OTHER PUBLIC B INS IN JUN00";
label variable OPBJL00 "COV BY OTHER PUBLIC B INS IN JUL00";
label variable OPBAU00 "COV BY OTHER PUBLIC B INS IN AUG00";
label variable OPBSE00 "COV BY OTHER PUBLIC B INS IN SEP00";
label variable OPBOC00 "COV BY OTHER PUBLIC B INS IN OCT00";
label variable OPBNO00 "COV BY OTHER PUBLIC B INS IN NOV00";
label variable OPBDE00 "COV BY OTHER PUBLIC B INS IN DEC00";
label variable STAJA00 "COVERED BY OTHER STATE PROG IN JAN00";
label variable STAFE00 "COVERED BY OTHER STATE PROG IN FEB00";
label variable STAMA00 "COVERED BY OTHER STATE PROG IN MAR00";
label variable STAAP00 "COVERED BY OTHER STATE PROG IN APR00";
label variable STAMY00 "COVERED BY OTHER STATE PROG IN MAY00";
label variable STAJU00 "COVERED BY OTHER STATE PROG IN JUN00";
label variable STAJL00 "COVERED BY OTHER STATE PROG IN JUL00";
label variable STAAU00 "COVERED BY OTHER STATE PROG IN AUG00";
label variable STASE00 "COVERED BY OTHER STATE PROG IN SEP00";
label variable STAOC00 "COVERED BY OTHER STATE PROG IN OCT00";
label variable STANO00 "COVERED BY OTHER STATE PROG IN NOV00";
label variable STADE00 "COVERED BY OTHER STATE PROG IN DEC00";
label variable PUBJA00X "COVR BY ANY PUBLIC INS IN JAN00 (ED)";
label variable PUBFE00X "COVR BY ANY PUBLIC INS IN FEB00 (ED)";
label variable PUBMA00X "COVR BY ANY PUBLIC INS IN MAR00 (ED)";
label variable PUBAP00X "COVR BY ANY PUBLIC INS IN APR00 (ED)";
label variable PUBMY00X "COVR BY ANY PUBLIC INS IN MAY00 (ED)";
label variable PUBJU00X "COVR BY ANY PUBLIC INS IN JUN00 (ED)";
label variable PUBJL00X "COVR BY ANY PUBLIC INS IN JUL00 (ED)";
label variable PUBAU00X "COVR BY ANY PUBLIC INS IN AUG00 (ED)";
label variable PUBSE00X "COVR BY ANY PUBLIC INS IN SEP00 (ED)";
label variable PUBOC00X "COVR BY ANY PUBLIC INS IN OCT00 (ED)";
label variable PUBNO00X "COVR BY ANY PUBLIC INS IN NOV00 (ED)";
label variable PUBDE00X "COVR BY ANY PUBLIC INS IN DEC00 (ED)";
label variable PEGJA00 "COVERED BY EMPL UNION INS IN JAN00";
label variable PEGFE00 "COVERED BY EMPL UNION INS IN FEB00";
label variable PEGMA00 "COVERED BY EMPL UNION INS IN MAR00";
label variable PEGAP00 "COVERED BY EMPL UNION INS IN APR00";
label variable PEGMY00 "COVERED BY EMPL UNION INS IN MAY00";
label variable PEGJU00 "COVERED BY EMPL UNION INS IN JUN00";
label variable PEGJL00 "COVERED BY EMPL UNION INS IN JUL00";
label variable PEGAU00 "COVERED BY EMPL UNION INS IN AUG00";
label variable PEGSE00 "COVERED BY EMPL UNION INS IN SEP00";
label variable PEGOC00 "COVERED BY EMPL UNION INS IN OCT00";
label variable PEGNO00 "COVERED BY EMPL UNION INS IN NOV00";
label variable PEGDE00 "COVERED BY EMPL UNION INS IN DEC00";
label variable PDKJA00 "COVR BY PRIV INS (SOURCE UNKNWN) JAN00";
label variable PDKFE00 "COVR BY PRIV INS (SOURCE UNKNWN) FEB00";
label variable PDKMA00 "COVR BY PRIV INS (SOURCE UNKNWN) MAR00";
label variable PDKAP00 "COVR BY PRIV INS (SOURCE UNKNWN) APR00";
label variable PDKMY00 "COVR BY PRIV INS (SOURCE UNKNWN) MAY00";
label variable PDKJU00 "COVR BY PRIV INS (SOURCE UNKNWN) JUN00";
label variable PDKJL00 "COVR BY PRIV INS (SOURCE UNKNWN) JUL00";
label variable PDKAU00 "COVR BY PRIV INS (SOURCE UNKNWN) AUG00";
label variable PDKSE00 "COVR BY PRIV INS (SOURCE UNKNWN) SEP00";
label variable PDKOC00 "COVR BY PRIV INS (SOURCE UNKNWN) OCT00";
label variable PDKNO00 "COVR BY PRIV INS (SOURCE UNKNWN) NOV00";
label variable PDKDE00 "COVR BY PRIV INS (SOURCE UNKNWN) DEC00";
label variable PNGJA00 "COVERED BY NONGROUP INS IN JAN00";
label variable PNGFE00 "COVERED BY NONGROUP INS IN FEB00";
label variable PNGMA00 "COVERED BY NONGROUP INS IN MAR00";
label variable PNGAP00 "COVERED BY NONGROUP INS IN APR00";
label variable PNGMY00 "COVERED BY NONGROUP INS IN MAY00";
label variable PNGJU00 "COVERED BY NONGROUP INS IN JUN00";
label variable PNGJL00 "COVERED BY NONGROUP INS IN JUL00";
label variable PNGAU00 "COVERED BY NONGROUP INS IN AUG00";
label variable PNGSE00 "COVERED BY NONGROUP INS IN SEP00";
label variable PNGOC00 "COVERED BY NONGROUP INS IN OCT00";
label variable PNGNO00 "COVERED BY NONGROUP INS IN NOV00";
label variable PNGDE00 "COVERED BY NONGROUP INS IN DEC00";
label variable POGJA00 "COVERED BY OTHER GROUP INS IN JAN00";
label variable POGFE00 "COVERED BY OTHER GROUP INS IN FEB00";
label variable POGMA00 "COVERED BY OTHER GROUP INS IN MAR00";
label variable POGAP00 "COVERED BY OTHER GROUP INS IN APR00";
label variable POGMY00 "COVERED BY OTHER GROUP INS IN MAY00";
label variable POGJU00 "COVERED BY OTHER GROUP INS IN JUN00";
label variable POGJL00 "COVERED BY OTHER GROUP INS IN JUL00";
label variable POGAU00 "COVERED BY OTHER GROUP INS IN AUG00";
label variable POGSE00 "COVERED BY OTHER GROUP INS IN SEP00";
label variable POGOC00 "COVERED BY OTHER GROUP INS IN OCT00";
label variable POGNO00 "COVERED BY OTHER GROUP INS IN NOV00";
label variable POGDE00 "COVERED BY OTHER GROUP INS IN DEC00";
label variable PRSJA00 "COVERED BY SELF-EMP-1 INS IN JAN00";
label variable PRSFE00 "COVERED BY SELF-EMP-1 INS IN FEB00";
label variable PRSMA00 "COVERED BY SELF-EMP-1 INS IN MAR00";
label variable PRSAP00 "COVERED BY SELF-EMP-1 INS IN APR00";
label variable PRSMY00 "COVERED BY SELF-EMP-1 INS IN MAY00";
label variable PRSJU00 "COVERED BY SELF-EMP-1 INS IN JUN00";
label variable PRSJL00 "COVERED BY SELF-EMP-1 INS IN JUL00";
label variable PRSAU00 "COVERED BY SELF-EMP-1 INS IN AUG00";
label variable PRSSE00 "COVERED BY SELF-EMP-1 INS IN SEP00";
label variable PRSOC00 "COVERED BY SELF-EMP-1 INS IN OCT00";
label variable PRSNO00 "COVERED BY SELF-EMP-1 INS IN NOV00";
label variable PRSDE00 "COVERED BY SELF-EMP-1 INS IN DEC00";
label variable POUJA00 "COVERED BY HOLDER OUTSIDE OF RU IN JAN00";
label variable POUFE00 "COVERED BY HOLDER OUTSIDE OF RU IN FEB00";
label variable POUMA00 "COVERED BY HOLDER OUTSIDE OF RU IN MAR00";
label variable POUAP00 "COVERED BY HOLDER OUTSIDE OF RU IN APR00";
label variable POUMY00 "COVERED BY HOLDER OUTSIDE OF RU IN MAY00";
label variable POUJU00 "COVERED BY HOLDER OUTSIDE OF RU IN JUN00";
label variable POUJL00 "COVERED BY HOLDER OUTSIDE OF RU IN JUL00";
label variable POUAU00 "COVERED BY HOLDER OUTSIDE OF RU IN AUG00";
label variable POUSE00 "COVERED BY HOLDER OUTSIDE OF RU IN SEP00";
label variable POUOC00 "COVERED BY HOLDER OUTSIDE OF RU IN OCT00";
label variable POUNO00 "COVERED BY HOLDER OUTSIDE OF RU IN NOV00";
label variable POUDE00 "COVERED BY HOLDER OUTSIDE OF RU IN DEC00";
label variable PRIJA00 "COVERED BY PRIVATE INS IN JAN00";
label variable PRIFE00 "COVERED BY PRIVATE INS IN FEB00";
label variable PRIMA00 "COVERED BY PRIVATE INS IN MAR00";
label variable PRIAP00 "COVERED BY PRIVATE INS IN APR00";
label variable PRIMY00 "COVERED BY PRIVATE INS IN MAY00";
label variable PRIJU00 "COVERED BY PRIVATE INS IN JUN00";
label variable PRIJL00 "COVERED BY PRIVATE INS IN JUL00";
label variable PRIAU00 "COVERED BY PRIVATE INS IN AUG00";
label variable PRISE00 "COVERED BY PRIVATE INS IN SEP00";
label variable PRIOC00 "COVERED BY PRIVATE INS IN OCT00";
label variable PRINO00 "COVERED BY PRIVATE INS IN NOV00";
label variable PRIDE00 "COVERED BY PRIVATE INS IN DEC00";
label variable HPEJA00 "HOLDER OF EMPL UNION INS IN JAN00";
label variable HPEFE00 "HOLDER OF EMPL UNION INS IN FEB00";
label variable HPEMA00 "HOLDER OF EMPL UNION INS IN MAR00";
label variable HPEAP00 "HOLDER OF EMPL UNION INS IN APR00";
label variable HPEMY00 "HOLDER OF EMPL UNION INS IN MAY00";
label variable HPEJU00 "HOLDER OF EMPL UNION INS IN JUN00";
label variable HPEJL00 "HOLDER OF EMPL UNION INS IN JUL00";
label variable HPEAU00 "HOLDER OF EMPL UNION INS IN AUG00";
label variable HPESE00 "HOLDER OF EMPL UNION INS IN SEP00";
label variable HPEOC00 "HOLDER OF EMPL UNION INS IN OCT00";
label variable HPENO00 "HOLDER OF EMPL UNION INS IN NOV00";
label variable HPEDE00 "HOLDER OF EMPL UNION INS IN DEC00";
label variable HPDJA00 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN00";
label variable HPDFE00 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB00";
label variable HPDMA00 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR00";
label variable HPDAP00 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR00";
label variable HPDMY00 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY00";
label variable HPDJU00 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN00";
label variable HPDJL00 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL00";
label variable HPDAU00 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG00";
label variable HPDSE00 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP00";
label variable HPDOC00 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT00";
label variable HPDNO00 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV00";
label variable HPDDE00 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC00";
label variable HPNJA00 "HOLDER OF NONGROUP INS IN JAN00";
label variable HPNFE00 "HOLDER OF NONGROUP INS IN FEB00";
label variable HPNMA00 "HOLDER OF NONGROUP INS IN MAR00";
label variable HPNAP00 "HOLDER OF NONGROUP INS IN APR00";
label variable HPNMY00 "HOLDER OF NONGROUP INS IN MAY00";
label variable HPNJU00 "HOLDER OF NONGROUP INS IN JUN00";
label variable HPNJL00 "HOLDER OF NONGROUP INS IN JUL00";
label variable HPNAU00 "HOLDER OF NONGROUP INS IN AUG00";
label variable HPNSE00 "HOLDER OF NONGROUP INS IN SEP00";
label variable HPNOC00 "HOLDER OF NONGROUP INS IN OCT00";
label variable HPNNO00 "HOLDER OF NONGROUP INS IN NOV00";
label variable HPNDE00 "HOLDER OF NONGROUP INS IN DEC00";
label variable HPOJA00 "HOLDER OF OTHER GROUP INS IN JAN00";
label variable HPOFE00 "HOLDER OF OTHER GROUP INS IN FEB00";
label variable HPOMA00 "HOLDER OF OTHER GROUP INS IN MAR00";
label variable HPOAP00 "HOLDER OF OTHER GROUP INS IN APR00";
label variable HPOMY00 "HOLDER OF OTHER GROUP INS IN MAY00";
label variable HPOJU00 "HOLDER OF OTHER GROUP INS IN JUN00";
label variable HPOJL00 "HOLDER OF OTHER GROUP INS IN JUL00";
label variable HPOAU00 "HOLDER OF OTHER GROUP INS IN AUG00";
label variable HPOSE00 "HOLDER OF OTHER GROUP INS IN SEP00";
label variable HPOOC00 "HOLDER OF OTHER GROUP INS IN OCT00";
label variable HPONO00 "HOLDER OF OTHER GROUP INS IN NOV00";
label variable HPODE00 "HOLDER OF OTHER GROUP INS IN DEC00";
label variable HPSJA00 "HOLDER OF SELF-EMP-1 INS IN JAN00";
label variable HPSFE00 "HOLDER OF SELF-EMP-1 INS IN FEB00";
label variable HPSMA00 "HOLDER OF SELF-EMP-1 INS IN MAR00";
label variable HPSAP00 "HOLDER OF SELF-EMP-1 INS IN APR00";
label variable HPSMY00 "HOLDER OF SELF-EMP-1 INS IN MAY00";
label variable HPSJU00 "HOLDER OF SELF-EMP-1 INS IN JUN00";
label variable HPSJL00 "HOLDER OF SELF-EMP-1 INS IN JUL00";
label variable HPSAU00 "HOLDER OF SELF-EMP-1 INS IN AUG00";
label variable HPSSE00 "HOLDER OF SELF-EMP-1 INS IN SEP00";
label variable HPSOC00 "HOLDER OF SELF-EMP-1 INS IN OCT00";
label variable HPSNO00 "HOLDER OF SELF-EMP-1 INS IN NOV00";
label variable HPSDE00 "HOLDER OF SELF-EMP-1 INS IN DEC00";
label variable HPRJA00 "HOLDER OF PRIVATE INSURANCE IN JAN00";
label variable HPRFE00 "HOLDER OF PRIVATE INSURANCE IN FEB00";
label variable HPRMA00 "HOLDER OF PRIVATE INSURANCE IN MAR00";
label variable HPRAP00 "HOLDER OF PRIVATE INSURANCE IN APR00";
label variable HPRMY00 "HOLDER OF PRIVATE INSURANCE IN MAY00";
label variable HPRJU00 "HOLDER OF PRIVATE INSURANCE IN JUN00";
label variable HPRJL00 "HOLDER OF PRIVATE INSURANCE IN JUL00";
label variable HPRAU00 "HOLDER OF PRIVATE INSURANCE IN AUG00";
label variable HPRSE00 "HOLDER OF PRIVATE INSURANCE IN SEP00";
label variable HPROC00 "HOLDER OF PRIVATE INSURANCE IN OCT00";
label variable HPRNO00 "HOLDER OF PRIVATE INSURANCE IN NOV00";
label variable HPRDE00 "HOLDER OF PRIVATE INSURANCE IN DEC00";
label variable INSJA00X "COVR BY HOSP/MED INS IN JAN00 (ED)";
label variable INSFE00X "COVR BY HOSP/MED INS IN FEB00 (ED)";
label variable INSMA00X "COVR BY HOSP/MED INS IN MAR00 (ED)";
label variable INSAP00X "COVR BY HOSP/MED INS IN APR00 (ED)";
label variable INSMY00X "COVR BY HOSP/MED INS IN MAY00 (ED)";
label variable INSJU00X "COVR BY HOSP/MED INS IN JUN00 (ED)";
label variable INSJL00X "COVR BY HOSP/MED INS IN JUL00 (ED)";
label variable INSAU00X "COVR BY HOSP/MED INS IN AUG00 (ED)";
label variable INSSE00X "COVR BY HOSP/MED INS IN SEP00 (ED)";
label variable INSOC00X "COVR BY HOSP/MED INS IN OCT00 (ED)";
label variable INSNO00X "COVR BY HOSP/MED INS IN NOV00 (ED)";
label variable INSDE00X "COVR BY HOSP/MED INS IN DEC00 (ED)";
label variable PRVEV00 "EVER HAVE PRIVATE INSURANCE DURING 00";
label variable TRIEV00 "EVER HAVE TIRCARE DURING 00";
label variable MCREV00 "EVER HAVE MEDICARE DURING 00";
label variable MCDEV00 "EVER HAVE MEDICAID DURING 00";
label variable OPAEV00 "EVER HAVE OTHER PUBLIC A INS DURING 00";
label variable OPBEV00 "EVER HAVE OTHER PUBLIC B INS DURING 00";
label variable UNINS00 "UNINSURED ALL OF 00";
label variable INSCOV00 "HEALTH INSURANCE COVERAGE INDICATOR 00";
label variable MCDHMO31 "COVERED BY MEDICAID HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID HMO - R4/2";
label variable MCDHMO00 "COVERED BY MEDICAID HMO - 12/31/00";
label variable MCDMC31 "COVERED BY MEDICAID GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COVERED BY MEDICAID GATEKEEPER PLAN-R4/2";
label variable MCDMC00 "COVERD BY MCAID GATEKEEPER PLAN-12/31/00";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO00 "COVERED BY PRIVATE HMO - 12/31/00";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC00 "COVERED BY PRIV GATEKEEPER PLAN-12/31/00";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PANL 5 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PANEL 5 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 5 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PNL 5 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 5 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID-PANEL 5 ONLY";
label variable WASCHAMP "WAS PREV INS CHAMPUS/CHAMPVA-PANL 5 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PANL 5 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PNL 5 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PANEL 5 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PANEL 5 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PANEL 5 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PANEL 5 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PANEL 5 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 5 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 5 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PNL 5 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 5 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PNL 5 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 5 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 5 ONLY";
label variable DENYINSR "PERS EVER DENIED INSUR-PANEL 5 ONLY";
label variable DNYCANC "CANCER CAUSE INSR DENIAL-PANEL 5 ONLY";
label variable DNYHYPER "HYPERTNS CAUSE INSUR DENIAL-PANEL 5 ONLY";
label variable DNYDIAB "DIABETES CAUSE INSUR DENIAL-PANEL 5 ONLY";
label variable DNYCORON "CORNRY ART DIS CAUSE INSR DNL-PNL 5 ONLY";
label variable DENYOTH "OTH REASON CAUS INSR DENIAL-PANEL 5 ONLY";
label variable INSLOOK "PERS EVER LOOK FOR INSURNCE-PANEL 5 ONLY";
label variable INSLIMIT "ANY LIMIT/RESTRIC INSURANCE-PANEL 5 ONLY";
label variable LMTBACK "COND CAUSED LIMIT:BACK PROB-PANEL 5 ONLY";
label variable LIMITOT "COND CAUSED LIMIT: OTHER-PANEL 5 ONLY";
label variable TRICR31X "COV BY TRICARE - RD 3/1 INT (ED)";
label variable TRICR42X "COV BY TRICARE - RD 4/2 INT (ED)";
label variable TRICR53X "COV BY TRICARE - RD 5/3 INT (ED)";
label variable TRICR00X "COV BY TRICARE - 12/31/00 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE - R5/3";
label variable TRIAT00X "ANY TIME COV TRICARE - 12/31/00";
label variable MCARE31 "PID COV BY MEDICARE - RD 31 INT";
label variable MCARE42 "PID COV BY MEDICARE - RD 42 INT";
label variable MCARE53 "PID COV BY MEDICARE - RD 53 INT";
label variable MCARE00 "PID COV BY MEDICARE - 12/31/00";
label variable MCARE31X "PID COV BY MEDICARE - RD 31 INT(ED)";
label variable MCARE42X "PID COV BY MEDICARE - RD 42 INT(ED)";
label variable MCARE53X "PID COV BY MEDICARE - RD 53 INT(ED)";
label variable MCARE00X "PID COV BY MEDICARE - 12/31/00 (ED)";
label variable MCAID31 "COV BY MCAID/SCHIP-RD 31 INT";
label variable MCAID42 "COV BY MCAID/SCHIP-RD 42 INT";
label variable MCAID53 "COV BY MCAID/SCHIP-RD 53 INT";
label variable MCAID00 "COV BY MCAID/SCHIP-12/31/00";
label variable MCAID31X "COV BY MCAID/SCHIP-RD 31 INT(ED)";
label variable MCAID42X "COV BY MCAID/SCHIP-RD 42 INT(ED)";
label variable MCAID53X "COV BY MCAID/SCHIP-RD 53 INT(ED)";
label variable MCAID00X "COV BY MCAID/SCHIP-12/31/00(ED)";
label variable MCDAT31X "AT ANYTIME COVERAGE BY MCAID/SCHIP-RD 31";
label variable MCDAT42X "AT ANYTIME COVERAGE BY MCAID/SCHIP-RD 42";
label variable MCDAT53X "AT ANYTIME COVERAGE BY MCAID/SCHIP-RD 53";
label variable MCDAT00X "AT ANYTIME COVG BY MCAID/SCHIP-12/31/00";
label variable OTPUBA31 "COV BY/PAYS OTH GOV MCAID HMO-RD 31 INT";
label variable OTPUBA42 "COV BY/PAYS OTH GOV MCAID HMO-RD 42 INT";
label variable OTPUBA53 "COV BY/PAYS OTH GOV MCAID HMO-RD 53 INT";
label variable OTPUBA00 "COV BY/PAYS OTH GOV MCAID HMO-12/31/00";
label variable OTPAAT31 "ANY TIM COV BY/PAYS OTH GV MCD HMO-RD 31";
label variable OTPAAT42 "ANY TIM COV BY/PAYS OTH GV MCD HMO-RD 42";
label variable OTPAAT53 "ANY TIM COV BY/PAYS OTH GV MCD HMO-RD 53";
label variable OTPAAT00 "ANY TIM CV BY/PY OTH GV MCD HMO-12/31/00";
label variable OTPUBB31 "COV BY OTH GOV NOT MCAID HMO - RD 31 INT";
label variable OTPUBB42 "COV BY OTH GOV NOT MCAID HMO - RD 42 INT";
label variable OTPUBB53 "COV BY OTH GOV NOT MCAID HMO - RD 53 INT";
label variable OTPUBB00 "COV BY OTH GOV NOT MCAID HMO - 12/31/00";
label variable OTPBAT31 "ANY TIM CV BY OTH GV NOT MCAID HMO-R31";
label variable OTPBAT42 "ANY TIM CV BY OTH GV NOT MCAID HMO-R42";
label variable OTPBAT53 "ANY TIM CV BY OTH GV NOT MCAID HMO-R53";
label variable OTPBAT00 "AN TM CV BY OT GV NOT MCAID HMO-12/31/00";
label variable PUB31X "PID COV BY PUBLIC INS-RD 31 INT(ED)";
label variable PUB42X "PID COV BY PUBLIC INS-RD 42 INT(ED)";
label variable PUB53X "PID COV BY PUBLIC INS-RD 53 INT(ED)";
label variable PUB00X "PID COV BY PUBLIC INS - 12/31/00 (ED)";
label variable PUBAT31X "AT ANY TIME COV BY PUBLIC - RD 31";
label variable PUBAT42X "AT ANY TIME COV BY PUBLIC - RD 42";
label variable PUBAT53X "AT ANY TIME COV BY PUBLIC - RD 53";
label variable PUBAT00X "AT ANY TIME COV BY PUBLIC - 12/31/00";
label variable STAPR31 "PID COV BY STATE-SPECIFIC PROG-RD 31 INT";
label variable STAPR42 "PID COV BY STATE-SPECIFIC PROG-RD 42 INT";
label variable STAPR53 "PID COV BY STATE-SPECIFIC PROG-RD 53 INT";
label variable STAPR00 "PID COV BY STATE-SPECIFIC PROG-12/31/00";
label variable STPRAT31 "AT ANY TIME COVERAGE BY STATE INS-RD 31";
label variable STPRAT42 "AT ANY TIME COVERAGE BY STATE INS-RD 42";
label variable STPRAT53 "AT ANY TIME COVERAGE BY STATE INS-RD 53";
label variable STPRAT00 "AT ANY TIME COV BY STATE INS - 12/31/00";
label variable PRIEU31 "PID COV BY EMPL/UNION GRP INS-RD 31 INT";
label variable PRIEU42 "PID COV BY EMPL/UNION GRP INS-RD 42 INT";
label variable PRIEU53 "PID COV BY EMPL/UNION GRP INS-RD 53 INT";
label variable PRIEU00 "PID COV BY EMPL/UNION GRP INS - 12/31/00";
label variable PRING31 "PID COV BY NON-GROUP INS - RD 31 INT";
label variable PRING42 "PID COV BY NON-GROUP INS - RD 42 INT";
label variable PRING53 "PID COV BY NON-GROUP INS - RD 53 INT";
label variable PRING00 "PID COV BY NON-GROUP INS - 12/31/00";
label variable PRIOG31 "PID COV BY OTHER GROUP INS -RD 31 INT";
label variable PRIOG42 "PID COV BY OTHER GROUP INS -RD 42 INT";
label variable PRIOG53 "PID COV BY OTHER GROUP INS -RD 53 INT";
label variable PRIOG00 "PID COV BY OTHER GROUP INS - 12/31/00";
label variable PRIDK31 "PID COV BY PRIV INS (DK PLAN)-RD 31 INT";
label variable PRIDK42 "PID COV BY PRIV INS (DK PLAN)-RD 42 INT";
label variable PRIDK53 "PID COV BY PRIV INS (DK PLAN)-RD 53 INT";
label variable PRIDK00 "PID COV BY PRIV INS (DK PLAN) - 12/31/00";
label variable PRIS31 "PID COV BY SELF-EMP-1 INS - RD 31 INT";
label variable PRIS42 "PID COV BY SELF-EMP-1 INS - RD 42 INT";
label variable PRIS53 "PID COV BY SELF-EMP-1 INS - RD 53 INT";
label variable PRIS00 "PID COV BY SELF-EMP-1 INS - 12/31/00";
label variable PROUT31 "PID COV BY SOMEONE OUT OF RU-RD 31 INT";
label variable PROUT42 "PID COV BY SOMEONE OUT OF RU-RD 42 INT";
label variable PROUT53 "PID COV BY SOMEONE OUT OF RU-RD 53 INT";
label variable PROUT00 "PID COV BY SOMEONE OUT OF RU-12/31/00";
label variable PRIV31 "PID COV BY PRIV HLTH INS-RD 31 INT";
label variable PRIV42 "PID COV BY PRIV HLTH INS-RD 42 INT";
label variable PRIV53 "PID COV BY PRIV HLTH INS-RD 53 INT";
label variable PRIV00 "PID COV BY PRIV HLTH INS-12/31/00";
label variable PRIVAT31 "ANY TIME COV BY PRIVATE - RD 31";
label variable PRIVAT42 "ANY TIME COV BY PRIVATE - RD 42";
label variable PRIVAT53 "ANY TIME COV BY PRIVATE - RD 53";
label variable PRIVAT00 "ANY TIME COV BY PRIVATE - 12/31/00";
label variable INS31X "PID IS INSURED - RD 31 INT (ED)";
label variable INS42X "PID IS INSURED - RD 42 INT (ED)";
label variable INS53X "PID IS INSURED - RD 53 INT (ED)";
label variable INS00X "PID IS INSURED - 12/31/00 (ED)";
label variable INSAT31X "INSURED ANY TIME IN RD31";
label variable INSAT42X "INSURED ANY TIME IN RD42";
label variable INSAT53X "INSURED ANY TIME IN RD53";
label variable INSAT00X "INSURED ANY TIME 12/31/00/";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD31)";
label variable OTHDYS42 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD42)";
label variable OTHDYS53 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD53)";
label variable OTHNDD31 "# DAY MISSED WRK/SCH CARE FOR OTH(RD31)";
label variable OTHNDD42 "# DAY MISSED WRK/SCH CARE FOR OTH(RD42)";
label variable OTHNDD53 "# DAY MISSED WRK/SCH CARE FOR OTH(RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT";
label variable HAVEUS42 "AC01 DOES PERSON HAVE A USC PROVIDER?";
label variable YNOUSC42 "AC03 MAIN REASON PERS DOESN T HAVE A USC";
label variable NOREAS42 "AC04 OTH REAS NO USC: NO OTHER REASONS";
label variable SELDSI42 "AC04 OTH REAS NO USC: SELDOM OR NEV SICK";
label variable NEWARE42 "ACO4 OTH REAS NO USC: RECENTLY MOVED";
label variable DKWHRU42 "AC04 OTH REAS NO USC: DK WHERE TO GO";
label variable USCNOT42 "AC04 OTH REAS NO USC: USC NOT AVAILABLE";
label variable PERSLA42 "AC04 OTH REAS NO USC: LANGUAGE";
label variable DIFFPL42 "AC04 OTH REAS NO USC: DIFFERENT PLACES";
label variable INSRPL42 "AC04 OTH REAS NO USC: JUST CHANGED INSUR";
label variable MYSELF42 "AC04 OTH REAS NO USC: NO DOCS/TREAT SELF";
label variable CARECO42 "AC04 OTH REAS NO USC: COST OF MED CARE";
label variable OTHINS42 "AC04 OTH REAS NO USC: INS RELATED REASON";
label variable OTHREA42 "AC04 OTH REAS NO USC: OTHER REASON";
label variable TYPEPL42 "USC TYPE OF PLACE";
label variable PROVTY42 "PROVIDER TYPE";
label variable YGOTOU42 "AC08 MAIN REASON PERS GOES TO HOSP USC";
label variable NOREA942 "AC09 OTH REAS GO TO USC:NO OTHER REASONS";
label variable LIKESU42 "AC09 OTH REAS GO TO USC: PREFERS/LIKES";
label variable DKELSE42 "AC09 OTH REAS GO TO USC:DK WH ELSE TO GO";
label variable AFFORD42 "AC09 OTH REAS GO TO USC:CAN T AFFORD OTH";
label variable OFFICE42 "AC09 OTH REAS GO TO USC:DR OFFICE AT OPD";
label variable AVAILT42 "AC09 OTH REAS GO TO USC: AVAIL WHEN TIME";
label variable CONVEN42 "AC09 OTH REAS GO TO USC: CONVENIENCE";
label variable BSTPLA42 "AC09 OTH REAS GO TO USC: BEST FOR COND";
label variable INSREA42 "AC09 OTH REAS GO TO USC:INSURANCE-RELATD";
label variable OTHRE942 "AC09 OTH REAS GO TO USC: OTHER REASON";
label variable GETTOU42 "AC09A HOW DOES PERSN GET TO USC PROVIDER";
label variable TYPEPE42 "USC TYPE OF PROVIDER";
label variable LOCATI42 "USC LOCATION";
label variable MINORP42 "AC14 GOTO USC FOR NEW HEALTH PROBLEM";
label variable PREVEN42 "AC14 GOTO USC FOR PREVENTIVE HEALTH CARE";
label variable REFFRL42 "AC14 GOTO USC FOR REFERRALS";
label variable OFFHOU42 "AC15 USC HAS OFFICE HRS NIGHTS/WEEKENDS";
label variable APPTWL42 "AC16 WHEN SEE USC,HAVE APPT OR WALK IN";
label variable APPDIF42 "AC17 HOW DIFFICULT TO GET APPT WITH USC";
label variable WAITTI42 "AC18 WITH APPT, HOW LONG TIL SEEN BY USC";
label variable PHONED42 "AC19 HOW DIFFICULT CONTACT USC BY PHONE";
label variable PRLIST42 "AC19A DOES USC PROV LISTEN?";
label variable TREATM42 "AC19B PROV ASK ABOUT OTHER TREATMENTS";
label variable CONFID42 "AC19C CONFIDENT IN USC PROV S ABILITY?";
label variable PROVST42 "AC19D HOW SATISFIED WITH USC STAFF";
label variable USCQUA42 "AC19E SATISFIED WITH QUALITY OF CARE";
label variable CHNGUS42 "AC20 HAS ANYONE CHANGED USC IN LAST YEAR";
label variable YCHNGU42 "AC21 WHY DID PERSON(S) CHANGE USC";
label variable ANYUSC42 "AC22 HAS ANYONE HAD A USC IN LAST YEAR";
label variable YNOMOR42 "AC23 WHY DON T THEY HAVE A USC ANYMORE?";
label variable NOCARE42 "AC24 DID ANYONE GO W/OUT HEALTH CARE?";
label variable HCNEED42 "AC24A SATISFIED FAMILY CAN GET CARE";
label variable OBTAIN42 "AC25 ANYONE HAVE DIFFICLTY OBTAIN CARE";
label variable MAINPR42 "AC25A MAIN REASON EXPERIENCED DIFFICULTY";
label variable NOOTHP42 "AC26 DIFFICULTY: NO OTHER PROBLEMS";
label variable NOAFFO42 "AC26 DIFFICULTY: COULDN T AFFORD CARE";
label variable INSNOP42 "AC26 DIFFICULTY: INS COMPANY WON T PAY";
label variable PREEXC42 "AC26 DIFFICULTY: PRE-EXISTING CONDITION";
label variable INSRQR42 "AC26 DIFFICULTY: INS REQUIRED REFERRAL";
label variable REFUSI42 "AC26 DIFFICULTY: DR REFUSED INS PLAN";
label variable DISTAN42 "AC26 DIFFICULTY: DISTANCE";
label variable PUBTRA42 "AC26 DIFFICULTY: PUBLIC TRANSPORTATION";
label variable EXPENS42 "AC26 DIFFICULTY: TOO EXPENS TO GET THERE";
label variable HEARPR42 "AC26 DIFFICULTY: HEARING IMPAIR/LOSS";
label variable LANGBA42 "AC26 DIFFICULTY: LANGUAGE BARRIER";
label variable INTOBL42 "AC26 DIFFICULTY: HARD TO GET INTO BLDG";
label variable INSIDE42 "AC26 DIFFICULTY: HARD TO GET AROUND";
label variable EQUIPM42 "AC26 DIFFICULTY: NO APPROPRIATE EQUIP";
label variable OFFWOR42 "AC26 DIFFICULTY: COULDN T GET TIME OFF";
label variable DKWHER42 "AC26 DIFFICULTY: DK WHERE TO GO";
label variable REFUSE42 "AC26 DIFFICULTY: WAS REFUSED SERVICES";
label variable CHLDCA42 "AC26 DIFFICULTY: COULDN T GET CHILD CARE";
label variable NOTIME42 "AC26 DIFFICULTY: NO TIME/TOOK TOO LONG";
label variable OTHRPR42 "AC26 DIFFICULTY: OTHER";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable RTPROX31 "SELF/PROXY RATING OF HEALTH - RD 3/1";
label variable RTPROX42 "SELF/PROXY RATING OF HEALTH - RD 4/2";
label variable RTPROX53 "SELF/PROXY RATING OF HEALTH - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable MNPROX31 "SELF/PROXY RATING OF MENTAL HEALTH-R3/1";
label variable MNPROX42 "SELF/PROXY RATING OF MENTAL HEALTH-R4/2";
label variable MNPROX53 "SELF/PROXY RATING OF MENTAL HEALTH-R5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM00 "ANY LIMITATION IN P4R3,4,5/P5R1,2,3";
label variable LIMACT42 "LIMITED IN ANY ACTIVITIES (<5 YR)-RD 4/2";
label variable PLYLIM42 "LIMITED IN PLAY ACTIVITY (<5 YRS)-RD 4/2";
label variable CANTPL42 "CAN T PARTICIPATE USUAL PLAY(<5 YR)-R4/2";
label variable SPCPRO42 "IN SPECIAL PROGRAM (<5 YRS) - RD 4/2";
label variable DPTSHT42 "IMMUNIZATION FOR DPT (<7 YRS) - RD 4/2";
label variable NUMDPT42 "ONE OR SEVERAL DPT SHOTS (<7 YRS)-RD 4/2";
label variable POLSHT42 "IMMUNIZATION FOR POLIO (<7 YRS)-RD 4/2";
label variable NUMPOL42 "ONE OR SEVERAL POLIO SHOTS (<7 YR)-RD4/2";
label variable MMRSHT42 "IMMUNIZATION MEASLES/MUMPS/RUBELLA-RD4/2";
label variable HEPSHT42 "IMMUNIZATION FOR HEPATITIS (<7 YR)-RD4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-RD4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-RD4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-RD4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-RD 4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - RD 4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PROBLEM GETTING ALONG W/SIB (5-17)-RD4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17) - R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17) - RD 4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-RD 4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-RD 4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-RD 4/2";
label variable SPCSCH42 "NEED SPECIAL SCHOOL PROGRAM (5-17)-RD4/2";
label variable SPECED42 "IN SPECIAL EDUCATION (5-17) - RD 4/2";
label variable SPCHTH42 "RECEIVED SPEECH THERAPY (5-17) - RD 4/2";
label variable PSYCNS42 "PSYCHOLOGICAL COUNSELING (5-17) - RD 4/2";
label variable OCUPTH42 "RECEIVED OCCUPATIONAL THRPY (5-17)-R4/2";
label variable VOCSVC42 "RECEIVED VOCATIONAL SERVICES (5-17)-R4/2";
label variable TUTOR42 "RECEIVED TUTORING (5-17) - RD 4/2";
label variable READIN42 "USED READER OR INTERPRETER (5-17)-RD 4/2";
label variable PHYTHR42 "RECEIVED PHYSICAL THERAPY (5-17)-RD 4/2";
label variable LIFSKL42 "RECEIVED LIFE SKILLS TRAINING(5-17)-R4/2";
label variable FAMCNS42 "RECEIVED FAMILY COUNSELING (5-17)-RD 4/2";
label variable RECTHR42 "RECEIVED RECREATIONAL THRPY (5-17)-RD4/2";
label variable OTHSVC42 "RECEIVED OTH SCHOOL SERVICE (5-17)-RD4/2";
label variable CANTSC42 "LMTED/UNABLE TO GO TO SCHOOL (5-17)-R4/2";
label variable LMOACT42 "LMTED IN NON-SCHOOL ACTIVITY (5-17)-R4/2";
label variable HLTHY42 "CHILD RESISTS ILLNESS WELL (0-17)-RD 4/2";
label variable NTHLTH42 "LESS HLTHY THAN SAME AGE KIDS(0-17)-R4/2";
label variable GETSIC42 "CHILD CATCHES WHAT S AROUND (0-17)-RD4/2";
label variable HGTFT42 "CHILD S HEIGHT - FEET (0-17) - RD 4/2";
label variable HGTIN42 "CHILD S HEIGHT - INCHES (0-17) - RD 4/2";
label variable WGTLB42 "CHILD S WEIGHT - POUNDS (0-17) - RD 4/2";
label variable WGTOZ42 "CHILD S WEIGHT - OUNCES (0-17) - RD 4/2";
label variable CHLIM42 "CHILD HAS ANY LIMITATION (0-17) - RD 4/2";
label variable WHRCAR00 "WHERE WAS CHILD CARE PROVIDED IN 2000";
label variable WHOCAR00 "WHO PROVIDED CHILD CARE IN 2000";
label variable DAYCAR00 "CHILD CARE ARRANGEMENTS REQUIRED IN 2000";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable HGHTFT53 "PERSON HGT W/OUT SHOES-FEET (>17)-RD 5/3";
label variable HGHTIN53 "PERS HGT W/OUT SHOES - INCH (>17)-RD 5/3";
label variable WEIGHT53 "WEIGHT WITHOUT SHOES (>17) - RD 5/3";
label variable WGTEST53 "WEIGHT ESTIMATE (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASMED53 "TAKE MEDS FOR ASTHMA - RD 5/3";
label variable ASSTER53 "TAKE INHALED STEROIDS ASTHMA - RD 5/3";
label variable ASFLOW53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable AGEJUL01 "SAQ/PAQ: AGE AS OF JULY 1, 2000";
label variable SVERLANG "SAQ: LANGUAGE OF ADMINISTRATION FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNECR42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADDSMK42 "SAQ 12 MOS: DR ADVISED QUIT SMOKING";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12";
label variable ADPACC42 "SAQ 4 WKS: DID LESS B/C PHYS PROBS SF-12";
label variable ADPLMT42 "SAQ 4 WKS: LIMIT WK B/C PHYS PROBS SF-12";
label variable PCS42 "SAQ:PHYSICAL COMPNT SUMMARY SF12 IMPUTED";
label variable ADMACC42 "SAQ 4 WKS: DID LESS B/C MENT PROBS SF-12";
label variable ADMLMT42 "SAQ 4 WKS: LIM WK B/C MENT PROBS SF-12";
label variable MCS42 "SAQ:MENTAL COMPONET SUMMRY SF12 IMPUTED";
label variable SFFLAG42 "SAQ:PCS/MCS IMPUTATION FLAG SF-12";
label variable ADPAIN42 "SAQ 4 WKS: PAIN LIMITS NORMAL WORK SF-12";
label variable ADCALM42 "SAQ 4 WKS: FELT CALM/PEACEFUL SF-12";
label variable ADPEP42 "SAQ 4 WKS: HAD A LOT OF ENERGY SF-12";
label variable ADBLUE42 "SAQ 4 WKS: FELT DOWNHEARTED/BLUE SF-12";
label variable ADSOCA42 "SAQ 4 WKS: HLTH STOPPED SOC ACTIV SF-12";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADMOBI42 "SAQ HEALTH TODAY: MOBILITY EQ-5D";
label variable ADSELF42 "SAQ HEALTH TODAY: SELF-CARE EQ-5D";
label variable ADACTI42 "SAQ HEALTH TODAY: USUAL ACTIVITY EQ-5D";
label variable ADPAYN42 "SAQ HEALTH TODAY: PAIN/DISCOMFORT EQ-5D";
label variable ADDEPR42 "SAQ HLTH TODAY: ANXIETY/DEPRESSION EQ-5D";
label variable ADHLTH42 "SAQ: HEALTH TODAY VS PAST 12MOS";
label variable ADSCAL42 "SAQ SCALE: HEALTH STATE TODAY EQ-5D";
label variable EQU42 "SAQ: EQ-5D PREFERENCE BASED INDEX";
label variable CHPRX42 "PAQ: RELATIONSHIP OF PROXY TO CHILD";
label variable CHRTCR42 "PAQ 12 MOS: MAKE ROUTINE CARE APPT-R42";
label variable CHRTWW42 "PAQ 12 MOS: ROUT APPT WHEN WANTED-R42";
label variable CHILCR42 "PAQ 12 MOS: ILL/INJ NEEDING CARE-R42";
label variable CHILWW42 "PAQ 12 MOS: ILL/INJ CARE WHEN WANTED-R42";
label variable CHAPPT42 "PAQ 12MOS: HOW MANY OFF/CLINIC APPTS-R42";
label variable CHNECR42 "PAQ 12 MOS: PROBS GETTING NECES CARE-R42";
label variable CHLIST42 "PAQ 12 MOS: CHILD S DR LISTEN TO YOU-R42";
label variable CHEXPL42 "PAQ 12MOS: CHILD S DR EXPLAIN THINGS-R42";
label variable CHRESP42 "PAQ 12 MOS: CHILD S DR SHOW RESPECT-R42";
label variable CHPRTM42 "PAQ 12 MOS: CHILD S DR ENOUGH TIME-R42";
label variable CHHECR42 "PAQ 12 MOS: RATE CHILD S HEALTH CARE-R42";
label variable CHSPEC42 "PAQ 12 MOS: CHILD NEEDED SPECIALIST-R42";
label variable CHPRRE42 "PAQ 12MOS: PROB TO GET REFER TO SPEC-R42";
label variable CHPMED42 "PAQ LWIM: CHILD NEEDS PRESCRIB MED-R42";
label variable CHPMHB42 "PAQ LWIM:PMED FOR HLTH OR BEHAV COND-R42";
label variable CHPMCN42 "PAQ LWIM: PMED COND LAST 12+ MOS-R42";
label variable CHSERV42 "PAQ LWIM: CHILD NEEDS MED&OTH SERV-R42";
label variable CHSRHB42 "PAQ LWIM:SERV FOR HLTH OR BEHAV COND-R42";
label variable CHSRCN42 "PAQ LWIM: SERV COND LAST 12+ MOS-R42";
label variable CHLIMI42 "PAQ LWIM: LIMITED IN ANY WAY-R42";
label variable CHLIHB42 "PAQ LWIM:LIMIT FOR HEALTH/BEHAV COND-R42";
label variable CHLICO42 "PAQ LWIM: LIMIT COND LAST 12+ MOS-R42";
label variable CHTHER42 "PAQ LWIM:CHILD NEEDS SPECIAL THERAPY-R42";
label variable CHTHHB42 "PAQ LWIM:SPEC THERAPY FOR HLTH+ COND-R42";
label variable CHTHCO42 "PAQ LWIM: THERAPY COND LAST 12+ MOS-R42";
label variable CHCOUN42 "PAQ LWIM: CHILD NEEDS COUNSELING-R42";
label variable CHEMPB42 "PAQ LWIM:COUNSELNG PROB LAST 12+ MOS-R42";
label variable CSHCN42 "PAQ CHILD WITH SPECIAL HEALTH CARE NEEDS";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2000";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2000";
label variable DSEYE53 "DCS: LAST EYE EXAM WITH PUPILS DILATED";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable TOTTCH00 "TOTAL HEALTH CARE CHARGES 00, EXCL RX";
label variable TOTEXP00 "TOTAL HEALTH CARE EXP 00";
label variable TOTSLF00 "TOTAL AMT PAID BY SELF/FAMILY 00";
label variable TOTMCR00 "TOTAL AMT PAID BY MEDICARE 00";
label variable TOTMCD00 "TOTAL AMT PAID BY MEDICAID 00";
label variable TOTPRV00 "TOTAL AMT PAID BY PRIVATE INS 00";
label variable TOTVA00 "TOTAL AMT PAID BY VA 00";
label variable TOTTRI00 "TOTAL AMT PAID BY TRICARE 00";
label variable TOTOFD00 "TOTAL AMT PAID BY OTHER FEDERAL 00";
label variable TOTSTL00 "TOTAL AMT PAID BY OTH ST/LOCAL 00";
label variable TOTWCP00 "TOTAL AMT PAID BY WORKERS COMP 00";
label variable TOTOPR00 "TOTAL AMT PAID BY OTHER PRIVATE 00";
label variable TOTOPU00 "TOTAL AMT PAID BY OTHER PUBLIC 00";
label variable TOTOSR00 "TOTAL AMT PAID BY OTHER SOURCES 00";
label variable OBTOTV00 "# OFFICE-BASED PROVIDER VISITS 00";
label variable OBVTCH00 "OFFICE-BASED PROVIDER VISIT CHARGES 00";
label variable OBVEXP00 "TOTAL OFFICE-BASED EXP 00";
label variable OBVSLF00 "ALL OFFICE VISITS -SELF/FAMILY AMT 00";
label variable OBVMCR00 "ALL OFFICE VISITS -MEDICARE AMT 00";
label variable OBVMCD00 "ALL OFFICE VISITS -MEDICAID AMT 00";
label variable OBVPRV00 "ALL OFFICE VISITS -PRIVATE INS AMT 00";
label variable OBVVA00 "ALL OFFICE VISITS-VA AMT 00";
label variable OBVTRI00 "ALL OFFICE VISITS-TRICARE AMT 00";
label variable OBVOFD00 "ALL OFFICE VISITS-OTHER FEDERAL AMT 00";
label variable OBVSTL00 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 00";
label variable OBVWCP00 "ALL OFFICE VISITS -WORKERS COMP AMT 00";
label variable OBVOPR00 "ALL OFFICE VISITS - OTH PRIVATE AMT 00";
label variable OBVOPU00 "ALL OFFICE VISITS - OTH PUBLIC AMT 00";
label variable OBVOSR00 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 00";
label variable OBDRV00 "# OFFICE-BASED PHYSICIAN VISITS 00";
label variable OBDTCH00 "OFFICE-BASED PHYSICIAN VISIT CHARGES 00";
label variable OBDEXP00 "TOTAL OFF-BASED DR EXP 00";
label variable OBDSLF00 "DR OFFICE VISITS -SELF/FAMILY AMT 00";
label variable OBDMCR00 "DR OFFICE VISITS -MEDICARE AMT 00";
label variable OBDMCD00 "DR OFFICE VISITS -MEDICAID AMT 00";
label variable OBDPRV00 "DR OFFICE VISITS -PRIVATE INS AMT 00";
label variable OBDVA00 "DR OFFICE VISITS -VA AMT 00";
label variable OBDTRI00 "DR OFFICE VISITS -TRICARE AMT 00";
label variable OBDOFD00 "DR OFFICE VISITS -OTHER FEDERAL AMT 00";
label variable OBDSTL00 "DR OFFICE VISITS -OTH ST/LOCAL AMT 00";
label variable OBDWCP00 "DR OFFICE VISITS -WORKERS COMP AMT 00";
label variable OBDOPR00 "DR OFFICE VISITS - OTH PRIVATE AMT 00";
label variable OBDOPU00 "DR OFFICE VISITS - OTH PUBLIC AMT 00";
label variable OBDOSR00 "DR OFF VSTS - OTH UNCLASS SRCE AMT 00";
label variable OBOTHV00 "# OFFICE-BASED NON-PHYSICAN VISITS 00";
label variable OBOTCH00 "OFFICE-BASED NON-DR VISIT CHARGES 00";
label variable OBOEXP00 "TOTAL OFF-BASED NON-DR EXP 00";
label variable OBOSLF00 "NON-DR OFF VISTS -SELF/FAMILY AMT 00";
label variable OBOMCR00 "NON-DR OFF VISTS -MEDICARE AMT 00";
label variable OBOMCD00 "NON-DR OFF VISTS -MEDICAID AMT 00";
label variable OBOPRV00 "NON-DR OFF VISTS -PRIVATE INS AMT 00";
label variable OBOVA00 "NON-DR OFF VISTS -VA AMT 00";
label variable OBOTRI00 "NON-DR OFF VISTS -TRICARE AMT 00";
label variable OBOOFD00 "NON-DR OFF VISTS -OTHER FEDERAL AMT 00";
label variable OBOSTL00 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 00";
label variable OBOWCP00 "NON-DR OFF VISTS -WORKERS COMP AMT 00";
label variable OBOOPR00 "NON-DR OFF VISTS - OTH PRIVATE AMT 00";
label variable OBOOPU00 "NON-DR OFF VISTS - OTH PUBLIC AMT 00";
label variable OBOOSR00 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 00";
label variable OBCHIR00 "# OFFICE-BASED CHIROPRACTOR VISITS 00";
label variable OBCTCH00 "OFFICE-BASED CHIRO VISIT CHARGES 00";
label variable OBCEXP00 "TOTAL OFF-BASED CHIRO EXP 00";
label variable OBCSLF00 "CHIRO OFF VISITS -SELF/FAMILY AMT 00";
label variable OBCMCR00 "CHIRO OFF VISITS -MEDICARE AMT 00";
label variable OBCMCD00 "CHIRO OFF VISITS -MEDICAID AMT 00";
label variable OBCPRV00 "CHIRO OFF VISITS -PRIVATE INS AMT 00";
label variable OBCVA00 "CHIRO OFF VISITS -VA AMT 00";
label variable OBCTRI00 "CHIRO OFF VISITS -TRICARE AMT 00";
label variable OBCOFD00 "CHIRO OFF VISITS -OTHER FEDERAL AMT 00";
label variable OBCSTL00 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 00";
label variable OBCWCP00 "CHIRO OFF VISITS -WORKERS COMP AMT 00";
label variable OBCOPR00 "CHIRO OFF VISTS - OTHR PRIVATE AMT 00";
label variable OBCOPU00 "CHIRO OFF VISTS - OTHR PUBLIC AMT 00";
label variable OBCOSR00 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 00";
label variable OBNURS00 "# OFF-BASED NURSE/PRACTITIONER VISITS 00";
label variable OBNTCH00 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 00";
label variable OBNEXP00 "TOTAL OFF-BASED NURSE/PRAC 00";
label variable OBNSLF00 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 00";
label variable OBNMCR00 "NURSE/PRAC OFF VISITS -MEDICARE AMT 00";
label variable OBNMCD00 "NURSE/PRAC OFF VSTS -MEDICAID AMT 00";
label variable OBNPRV00 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 00";
label variable OBNVA00 "NURSE/PRAC OFF VSTS -VA AMT 00";
label variable OBNTRI00 "NURSE/PRAC OFF VSTS -TRICARE AMT 00";
label variable OBNOFD00 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 00";
label variable OBNSTL00 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 00";
label variable OBNWCP00 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 00";
label variable OBNOPR00 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 00";
label variable OBNOPU00 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 00";
label variable OBNOSR00 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 00";
label variable OBOPTO00 "# OFF-BASED OPTOMETRIST VISITS 00";
label variable OBETCH00 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 00";
label variable OBEEXP00 "TOTAL OFF-BASED OPOTMETRIST EXP 00";
label variable OBESLF00 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 00";
label variable OBEMCR00 "OPTOMETRIST OFF VSTS -MEDICARE AMT 00";
label variable OBEMCD00 "OPTOMETRIST OFF VSTS -MEDICAID AMT 00";
label variable OBEPRV00 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 00";
label variable OBEVA00 "OPTOMETRIST OFF VSTS -VA AMT 00";
label variable OBETRI00 "OPTOMETRIST OFF VSTS -TRICARE AMT 00";
label variable OBEOFD00 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 00";
label variable OBESTL00 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 00";
label variable OBEWCP00 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 00";
label variable OBEOPR00 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 00";
label variable OBEOPU00 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 00";
label variable OBEOSR00 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 00";
label variable OBASST00 "# OFF-BASED PHYSICIAN ASSIST VISITS 00";
label variable OBATCH00 "OFFICE-BASED PHYS ASST VISIT CHARGES 00";
label variable OBAEXP00 "TOTAL OFF-BASED PHYS ASS T EXP 00";
label variable OBASLF00 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 00";
label variable OBAMCR00 "PHYS ASS T OFF VSTS -MEDICARE AMT 00";
label variable OBAMCD00 "PHYS ASS T OFF VSTS -MEDICAID AMT 00";
label variable OBAPRV00 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 00";
label variable OBAVA00 "PHYS ASS T OFF VSTS -VA AMT 00";
label variable OBATRI00 "PHYS ASS T OFF VSTS -TRICARE AMT 00";
label variable OBAOFD00 "PHYS ASS T OFF VSTS -OTHER FED AMT 00";
label variable OBASTL00 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 00";
label variable OBAWCP00 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 00";
label variable OBAOPR00 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 00";
label variable OBAOPU00 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 00";
label variable OBAOSR00 "P A OFF VSTS - OTH UNCLASS SRCE AMT 00";
label variable OBTHER00 "# OFF-BASED PT/OT VISITS 00";
label variable OBTTCH00 "OFFICE-BASED PT/OC VISIT CHARGES 00";
label variable OBTEXP00 "TOT OFF-BASED PT EXP 00";
label variable OBTSLF00 "PT/OT OFF VISITS -SELF/FAMILY AMT 00";
label variable OBTMCR00 "PT/OT OFF VISITS -MEDICARE AMT 00";
label variable OBTMCD00 "PT/OT OFF VISITS -MEDICAID AMT 00";
label variable OBTPRV00 "PT/OT OFF VISITS -PRIVATE INS AMT 00";
label variable OBTVA00 "PT/OT OFF VISITS -VA AMT 00";
label variable OBTTRI00 "PT/OT OFF VISITS -TRICARE AMT 00";
label variable OBTOFD00 "PT/OT OFF VISITS -OTHER FED AMT 00";
label variable OBTSTL00 "PT/OT OFF VISITS -OTH ST/LOCL AMT 00";
label variable OBTWCP00 "PT/OT OFF VISITS -WORKERS COMP AMT 00";
label variable OBTOPR00 "PT/OT OFF VISITS - OTH PRIVATE AMT 00";
label variable OBTOPU00 "PT/OT OFF VISITS - OTH PUBLIC AMT 00";
label variable OBTOSR00 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 00";
label variable OPTOTV00 "# OUTPATIENT DEPT PROVIDER VISITS 00";
label variable OPFTCH00 "OPD PROVIDER VISIT CHARGES - FAC 00";
label variable OPFEXP00 "TOTAL OUTPATIENT FACILITY EXP 00";
label variable OPFSLF00 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 00";
label variable OPFMCR00 "ALL OPD VISITS-MEDICARE AMT-FAC 00";
label variable OPFMCD00 "ALL OPD VISITS-MEDICAID AMT-FAC 00";
label variable OPFPRV00 "ALL OPD VISITS-PRIV INS AMT-FAC 00";
label variable OPFVA00 "ALL OPD VISITS-VA AMT-FAC 00";
label variable OPFTRI00 "ALL OPD VISITS-TRICARE AMT-FAC 00";
label variable OPFOFD00 "ALL OPD VISITS-OTHER FED AMT-FAC 00";
label variable OPFSTL00 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 00";
label variable OPFWCP00 "ALL OPD VISITS-WORKERS COMP AMT-FAC 00";
label variable OPFOPR00 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 00";
label variable OPFOPU00 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 00";
label variable OPFOSR00 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 00";
label variable OPDEXP00 "TOTAL OUTPATIENT PROVIDER EXP 00";
label variable OPDTCH00 "OPD PROVIDER VISIT CHARGES - DR 00";
label variable OPDSLF00 "ALL OPD VISITS-SELF/FAMILY AMT-DR 00";
label variable OPDMCR00 "ALL OPD VISITS-MEDICARE AMT -DR 00";
label variable OPDMCD00 "ALL OPD VISITS-MEDICAID AMT -DR 00";
label variable OPDPRV00 "ALL OPD VISITS-PRIV INS AMT-DR 00";
label variable OPDVA00 "ALL OPD VISITS-VA AMT-DR 00";
label variable OPDTRI00 "ALL OPD VISITS-TRICARE AMT-DR 00";
label variable OPDOFD00 "ALL OPD VISITS-OTHER FED AMT-DR 00";
label variable OPDSTL00 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 00";
label variable OPDWCP00 "ALL OPD VISITS-WORKERS COMP AMT-DR 00";
label variable OPDOPR00 "ALL OPD VISITS - OTH PRIVATE AMT-DR 00";
label variable OPDOPU00 "ALL OPD VISITS-OTH PUBLIC AMT-DR 00";
label variable OPDOSR00 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 00";
label variable OPDRV00 "# OUTPATIENT DEPT PHYSICIAN VISITS 00";
label variable OPVTCH00 "OPD PHYSICIAN VISIT CHARGES - FAC 00";
label variable OPVEXP00 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 00";
label variable OPVSLF00 "OPD DR VISITS-SELF/FAMILY AMT-FAC 00";
label variable OPVMCR00 "OPD DR VISITS-MEDICARE AMT-FAC 00";
label variable OPVMCD00 "OPD DR VISITS-MEDICAID AMT-FAC 00";
label variable OPVPRV00 "OPD DR VISITS-PRIV INS AMT-FAC 00";
label variable OPVVA00 "OPD DR VISITS-VA AMT-FAC 00";
label variable OPVTRI00 "OPD DR VISITS-TRICARE AMT-FAC 00";
label variable OPVOFD00 "OPD DR VISITS-OTHER FED AMT-FAC 00";
label variable OPVSTL00 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 00";
label variable OPVWCP00 "OPD DR VISITS-WORKERS COMP AMT-FAC 00";
label variable OPVOPR00 "OPD DR VISITS - OTH PRIVATE AMT-FAC 00";
label variable OPVOPU00 "OPD DR VISITS-OTH PUBLIC AMT-FAC 00";
label variable OPVOSR00 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 00";
label variable OPSEXP00 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 00";
label variable OPSTCH00 "OPD PHYSICIAN VISIT CHARGES - DR 00";
label variable OPSSLF00 "OPD DR VISITS-SELF/FAMILY AMT-DR 00";
label variable OPSMCR00 "OPD DR VISITS-MEDICARE AMT-DR 00";
label variable OPSMCD00 "OPD DR VISITS-MEDICAID AMT-DR 00";
label variable OPSPRV00 "OPD DR VISITS-PRIV INS AMT-DR 00";
label variable OPSVA00 "OPD DR VISITS-VA AMT-DR 00";
label variable OPSTRI00 "OPD DR VISITS-TRICARE AMT-DR 00";
label variable OPSOFD00 "OPD DR VISITS-OTHER FED AMT-DR 00";
label variable OPSSTL00 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 00";
label variable OPSWCP00 "OPD DR VISITS-WORKERS COMP AMT-DR 00";
label variable OPSOPR00 "OPD DR VISITS - OTH PRIVATE AMT-DR 00";
label variable OPSOPU00 "OPD DR VISITS-OTH PUBLIC AMT-DR 00";
label variable OPSOSR00 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 00";
label variable OPOTHV00 "# OUTPATIENT DEPT NON-DR VISITS 00";
label variable OPOTCH00 "OPD NON-PHYS VISIT CHARGES - FAC 00";
label variable OPOEXP00 "TOTAL OUTPATIENT NON-DR - FAC EXP 00";
label variable OPOSLF00 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 00";
label variable OPOMCR00 "OPD NON-DR VISITS-MEDICARE AMT-FAC 00";
label variable OPOMCD00 "OPD NON-DR VISITS-MEDICAID AMT-FAC 00";
label variable OPOPRV00 "OPD NON-DR VISITS-PRIV INS AMT-FAC 00";
label variable OPOVA00 "OPD NON-DR VISITS-VA AMT-FAC 00";
label variable OPOTRI00 "OPD NON-DR VISITS-TRICARE AMT-FAC 00";
label variable OPOOFD00 "OPD NON-DR VISITS-OTHER FED AMT-FAC 00";
label variable OPOSTL00 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 00";
label variable OPOWCP00 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 00";
label variable OPOOPR00 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 00";
label variable OPOOPU00 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 00";
label variable OPOOSR00 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 00";
label variable OPPEXP00 "TOTAL OUTPATIENT NON-DR - DR EXP 00";
label variable OPPTCH00 "OPD NON-PHYS VISIT CHARGES - DR 00";
label variable OPPSLF00 "OPD NON-DR VISITS-SELF/FAM AMT-DR 00";
label variable OPPMCR00 "OPD NON-DR VISITS-MEDICARE AMT-DR 00";
label variable OPPMCD00 "OPD NON-DR VISITS-MEDICAID AMT-DR 00";
label variable OPPPRV00 "OPD NON-DR VISITS-PRIV INS AMT-DR 00";
label variable OPPVA00 "OPD NON-DR VISITS-VA AMT-DR 00";
label variable OPPTRI00 "OPD NON-DR VISITS-TRICARE AMT-DR 00";
label variable OPPOFD00 "OPD NON-DR VISITS-OTHER FED AMT-DR 00";
label variable OPPSTL00 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 00";
label variable OPPWCP00 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 00";
label variable OPPOPR00 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 00";
label variable OPPOPU00 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 00";
label variable OPPOSR00 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 00";
label variable AMCHIR00 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2000";
label variable AMCTCH00 "CHIRO AMBULATORY VISIT CHARGES 00";
label variable AMCEXP00 "TOTL AMBULTRY (OB+OP) CHIRO EXP 00";
label variable AMCSLF00 "CHIRO AMB VISITS -SELF/FAMILY AMT 00";
label variable AMCMCR00 "CHIRO AMB VISITS -MEDICARE AMT 00";
label variable AMCMCD00 "CHIRO AMB VISITS -MEDICAID AMT 00";
label variable AMCPRV00 "CHIRO AMB VISITS -PRIVATE INS AMT 00";
label variable AMCVA00 "CHIRO AMB VISITS -VA AMT 00";
label variable AMCTRI00 "CHIRO AMB VISITS-TRICARE AMT 00";
label variable AMCOFD00 "CHIRO AMB VISITS -OTHER FEDERAL AMT 00";
label variable AMCSTL00 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 00";
label variable AMCWCP00 "CHIRO AMB VISITS-WORKERS COMP AMT 00";
label variable AMCOPR00 "CHIRO AMB VISITS - OTH PRIVATE AMT 00";
label variable AMCOPU00 "CHIRO AMB VISITS - OTH PUBLIC AMT 00";
label variable AMCOSR00 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 00";
label variable AMNURS00 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 00";
label variable AMNTCH00 "NRS/PRAC AMBULATORY VISIT CHARGES 00";
label variable AMNEXP00 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 00";
label variable AMNSLF00 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 00";
label variable AMNMCR00 "NRS/PRAC AMB VSTS -MEDICARE AMT 00";
label variable AMNMCD00 "NRS/PRAC AMB VSTS -MEDICAID AMT 00";
label variable AMNPRV00 "NRS/PRAC AMB VSTS -PRIV INS AMT 00";
label variable AMNVA00 "NRS/PRAC AMB VSTS-VA AMT 00";
label variable AMNTRI00 "NRS/PRAC AMB VSTS-TRICARE AMT 00";
label variable AMNOFD00 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 00";
label variable AMNSTL00 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 00";
label variable AMNWCP00 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 00";
label variable AMNOPR00 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 00";
label variable AMNOPU00 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 00";
label variable AMNOSR00 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 00";
label variable AMOPTO00 "# AMB OPTOMETRIST VSTS (OB+OP) 00";
label variable AMETCH00 "OPTOMETRIST AMBULATORY VISIT CHARGES 00";
label variable AMEEXP00 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 00";
label variable AMESLF00 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 00";
label variable AMEMCR00 "OPTMTRIST AMB VSTS -MEDICARE AMT 00";
label variable AMEMCD00 "OPTMTRIST AMB VSTS -MEDICAID AMT 00";
label variable AMEPRV00 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 00";
label variable AMEVA00 "OPTMTRIST AMB VSTS-VA AMT 00";
label variable AMETRI00 "OPTMTRIST AMB VSTS-TRICARE AMT 00";
label variable AMEOFD00 "OPTMTRIST AMB VSTS-OTHER FED AMT 00";
label variable AMESTL00 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 00";
label variable AMEWCP00 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 00";
label variable AMEOPR00 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 00";
label variable AMEOPU00 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 00";
label variable AMEOSR00 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 00";
label variable AMASST00 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2000";
label variable AMATCH00 "PHYS ASS T AMBULATORY VISIT CHARGES 00";
label variable AMAEXP00 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 00";
label variable AMASLF00 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 00";
label variable AMAMCR00 "PHYS ASS T AMB VSTS-MEDICARE AMT 00";
label variable AMAMCD00 "PHYS ASS T AMB VSTS-MEDICAID AMT 00";
label variable AMAPRV00 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 00";
label variable AMAVA00 "PHYS ASS T AMB VSTS-VA AMT 00";
label variable AMATRI00 "PHYS ASS T AMB VSTS-TRICARE AMT 00";
label variable AMAOFD00 "PHYS ASS T AMB VSTS -OTHER FED AMT 00";
label variable AMASTL00 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 00";
label variable AMAWCP00 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 00";
label variable AMAOPR00 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 00";
label variable AMAOPU00 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 00";
label variable AMAOSR00 "P A AMB VSTS- OTH UNCLASS SRCE AMT 00";
label variable AMTHER00 "# AMB PT/OT THRPY VISITS (OB+OP) 00";
label variable AMTTCH00 "PT/OC AMBULATORY VISIT CHARGES 00";
label variable AMTEXP00 "TOTL AMBULTRY (OB+OP) PT/OT EXP 00";
label variable AMTSLF00 "PT/OT AMB VISITS-SELF/FAMILY AMT 00";
label variable AMTMCR00 "PT/OT AMB VISITS-MEDICARE AMT 00";
label variable AMTMCD00 "PT/OT AMB VISITS-MEDICAID AMT 00";
label variable AMTPRV00 "PT/OT AMB VISITS-PRIVATE INS AMT 00";
label variable AMTVA00 "PT/OT AMB VISITS-VA AMT 00";
label variable AMTTRI00 "PT/OT AMB VISITS-TRICARE AMT 00";
label variable AMTOFD00 "PT/OT AMB VISITS -OTHER FED AMT 00";
label variable AMTSTL00 "PT/OT AMB VISITS-OTH ST/LOCL AMT 00";
label variable AMTWCP00 "PT/OT AMB VISITS-WORKERS COMP AMT 00";
label variable AMTOPR00 "PT/OT AMB VISITS - OTH PRIVATE AMT 00";
label variable AMTOPU00 "PT/OT AMB VISITS-OTH PUBLIC AMT 00";
label variable AMTOSR00 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 00";
label variable AMTOTC00 "# CALLS W/OFFICE & OUPAT DEPTS, 2000";
label variable AMDRC00 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2000";
label variable ERTOT00 "# EMERGENCY ROOM VISITS 00";
label variable ERFTCH00 "ER FACILITY VISIT CHARGES 00";
label variable ERFEXP00 "TOTAL ER FACILITY EXP 00";
label variable ERFSLF00 "ER-SELF/FAMILY AMT - FAC 00";
label variable ERFMCR00 "ER-MEDICARE AMT - FAC 00";
label variable ERFMCD00 "ER-MEDICAID AMT - FAC 00";
label variable ERFPRV00 "ER-PRIVATE INS AMT - FAC 00";
label variable ERFVA00 "ER-VA AMT - FAC 00";
label variable ERFTRI00 "ER-TRICARE AMT - FAC 00";
label variable ERFOFD00 "ER-OTHER FEDERAL AMT - FAC 00";
label variable ERFSTL00 "ER-OTH ST/LOCAL AMT - FAC 00";
label variable ERFWCP00 "ER-WORKERS COMP AMT - FAC 00";
label variable ERFOPR00 "ER-OTHER PRIVATE AMT - FAC 00";
label variable ERFOPU00 "ER-OTHER PUBLIC AMT - FAC 00";
label variable ERFOSR00 "ER-OTH UNCLASS SRCE AMT - FAC 00";
label variable ERDEXP00 "TOTAL EMERGENCY ROOM DR EXP 00";
label variable ERDTCH00 "ER DOCTOR VISIT CHARGES 00";
label variable ERDSLF00 "ER-SELF/FAMILY AMT - DR 00";
label variable ERDMCR00 "ER-MEDICARE AMT - DR 00";
label variable ERDMCD00 "ER-MEDICAID AMT - DR 00";
label variable ERDPRV00 "ER-PRIVATE INS AMT - DR 00";
label variable ERDVA00 "ER-VA AMT - DR 00";
label variable ERDTRI00 "ER-TRICARE AMT - DR 00";
label variable ERDOFD00 "ER-OTHER FED AMT - DR 00";
label variable ERDSTL00 "ER-OTH ST/LOCAL AMT - DR 00";
label variable ERDWCP00 "ER-WORKERS COMP AMT - DR 00";
label variable ERDOPR00 "ER - OTHER PRIVATE AMT - DR 00";
label variable ERDOPU00 "ER - OTHER PUBLIC AMT - DR 00";
label variable ERDOSR00 "ER-OTH UNCLASS SRCE AMT - DR 00";
label variable IPZERO00 "# ZERO-NIGHT HOSPITAL STAYS 00";
label variable ZIFTCH00 "ZERO-NITE IP STAY CHARGES - FAC 00";
label variable ZIFEXP00 "TOTAL ZERO-NITE STAYS FAC EXP 00";
label variable ZIFSLF00 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 00";
label variable ZIFMCR00 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 00";
label variable ZIFMCD00 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 00";
label variable ZIFPRV00 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 00";
label variable ZIFVA00 "ZERO-NITE IP STAZ-VA AMT-FAC 00";
label variable ZIFTRI00 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 00";
label variable ZIFOFD00 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 00";
label variable ZIFSTL00 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 00";
label variable ZIFWCP00 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 00";
label variable ZIFOPR00 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 00";
label variable ZIFOPU00 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 00";
label variable ZIFOSR00 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 00";
label variable ZIDEXP00 "TOTAL ZERO-NITE STAZ DR 00";
label variable ZIDTCH00 "ZERO-NITE IP STAY CHARGES - DR 00";
label variable ZIDSLF00 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 00";
label variable ZIDMCR00 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 00";
label variable ZIDMCD00 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 00";
label variable ZIDPRV00 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 00";
label variable ZIDVA00 "ZERO-NITE IP STAZ-VA AMT-DR 00";
label variable ZIDTRI00 "ZERO-NITE IP STAZ-TRICARE AMT-DR 00";
label variable ZIDOFD00 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 00";
label variable ZIDSTL00 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 00";
label variable ZIDWCP00 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 00";
label variable ZIDOPR00 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 00";
label variable ZIDOPU00 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 00";
label variable ZIDOSR00 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 00";
label variable IPDIS00 "# HOSPITAL DISCHARGES, 2000";
label variable IPFEXP00 "TOT HOSP IP FACILITY EXP-INC 0 NITES 00";
label variable IPFTCH00 "IP HOSP STAY CHARGES - FAC 00";
label variable IPFSLF00 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 00";
label variable IPFMCR00 "IP HOSP STAZ-MEDICARE AMT-FAC 00";
label variable IPFMCD00 "IP HOSP STAZ-MEDICAID AMT-FAC 00";
label variable IPFPRV00 "IP HOSP STAZ-PRIV INS AMT-FAC 00";
label variable IPFVA00 "IP HOSP STAZ-VA AMT-FAC 00";
label variable IPFTRI00 "IP HOSP STAZ-TRICARE AMT-FAC 00";
label variable IPFOFD00 "IP HOSP STAZ-OTHER FED AMT-FAC 00";
label variable IPFSTL00 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 00";
label variable IPFWCP00 "IP HOSP STAZ-WORKERS COMP AMT-FAC 00";
label variable IPFOPR00 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 00";
label variable IPFOPU00 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 00";
label variable IPFOSR00 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 00";
label variable IPDEXP00 "TOTL HOSP STAZ DR EXP 00";
label variable IPDTCH00 "IP HOSP STAY CHARGES - DR 00";
label variable IPDSLF00 "IP HOSP STAZ-SELF/FAMILY AMT-DR 00";
label variable IPDMCR00 "IP HOSP STAZ-MEDICARE AMT- DR 00";
label variable IPDMCD00 "IP HOSP STAZ-MEDICAID AMT-DR 00";
label variable IPDPRV00 "IP HOSP STAZ-PRIV INS AMT- DR 00";
label variable IPDVA00 "IP HOSP STAZ-VA AMT-DR 00";
label variable IPDTRI00 "IP HOSP STAZ-TRICARE AMT-DR 00";
label variable IPDOFD00 "IP HOSP STAZ-OTHER FED AMT-DR 00";
label variable IPDSTL00 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 00";
label variable IPDWCP00 "IP HOSP STAZ-WORKERS COMP AMT-DR 00";
label variable IPDOPR00 "IP HOSP STAZ - OTH PRIVATE AMT-DR 00";
label variable IPDOPU00 "IP HOSP STAZ - OTH PUBLIC AMT-DR 00";
label variable IPDOSR00 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 00";
label variable IPNGTD00 "# NIGHTS IN HOSP FOR DISCHARGES, 2000";
label variable DVTOT00 "# DENTAL CARE VISITS 00";
label variable DVTTCH00 "TOTAL DENTAL CARE VISIT CHARGES 00";
label variable DVTEXP00 "TOTAL DENTAL CARE EXP 00";
label variable DVTSLF00 "ALL DENTAL CARE -SELF/FAMILY AMT 00";
label variable DVTMCR00 "ALL DENTAL CARE -MEDICARE AMT 00";
label variable DVTMCD00 "ALL DENTAL CARE -MEDICAID AMT 00";
label variable DVTPRV00 "ALL DENTAL CARE -PRIVATE INS AMT 00";
label variable DVTVA00 "ALL DENTAL CARE -VA AMT 00";
label variable DVTTRI00 "ALL DENTAL CARE -TRICARE AMT 00";
label variable DVTOFD00 "ALL DENTAL CARE -OTHER FEDRL AMT 00";
label variable DVTSTL00 "ALL DENTAL CARE -OTH ST/LOCAL AMT 00";
label variable DVTWCP00 "ALL DENTAL CARE -WORKERS COMP AMT 00";
label variable DVTOPR00 "ALL DENTAL CARE - OTH PRIVATE AMT 00";
label variable DVTOPU00 "ALL DENTAL CARE - OTH PUBLIC AMT 00";
label variable DVTOSR00 "ALL DENT CARE-OT UNCLASS SRCE AMT 00";
label variable DVGEN00 "# GENERAL DENTIST VISITS 00";
label variable DVGTCH00 "GENERAL DENTAL CARE VISIT CHARGES 00";
label variable DVGEXP00 "TOTAL GENERAL DENTIST EXP 00";
label variable DVGSLF00 "GNRL DENTAL VISITS -SELF/FAM AMT 00";
label variable DVGMCR00 "GNRL DENTAL VISITS -MEDICARE AMT 00";
label variable DVGMCD00 "GNRL DENTAL VISITS -MEDICAID AMT 00";
label variable DVGPRV00 "GNRL DENTAL VISITS -PRIVATE INS AMT 00";
label variable DVGVA00 "GNRL DENTAL VISITS -VA AMT 00";
label variable DVGTRI00 "GNRL DENTAL VISITS-TRICARE AMT 00";
label variable DVGOFD00 "GNRL DENTAL VISITS- OTHER FED AMT 00";
label variable DVGSTL00 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 00";
label variable DVGWCP00 "GNRL DENTAL VISITS - WORKERS COMP AMT 00";
label variable DVGOPR00 "GNRL DENTAL VISITS - OTH PRIVATE AMT 00";
label variable DVGOPU00 "GNRL DENTAL VISITS - OTH PUBLIC AMT 00";
label variable DVGOSR00 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 00";
label variable DVORTH00 "# ORTHODONTIST VISITS 00";
label variable DVOTCH00 "ORTHODONTIST VISIT CHARGES 00";
label variable DVOEXP00 "TOTAL ORTHODONTIST EXP 00";
label variable DVOSLF00 "ORTHODONTIST VISITS -SELF/FAMILY AMT 00";
label variable DVOMCR00 "ORTHODONTIST VISITS -MEDICARE AMT 00";
label variable DVOMCD00 "ORTHODONTIST VISITS -MEDICAID AMT 00";
label variable DVOPRV00 "ORTHODONTIST VISITS -PRIVATE INS AMT 00";
label variable DVOVA00 "ORTHODONTIST VISITS-VA AMT 00";
label variable DVOTRI00 "ORTHODONTIST VISITS-TRICARE AMT 00";
label variable DVOOFD00 "ORTHODONTIST VISITS-OTHR FED AMT 00";
label variable DVOSTL00 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 00";
label variable DVOWCP00 "ORTHODONTIST VISITS-WORKERS COMP AMT 00";
label variable DVOOPR00 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 00";
label variable DVOOPU00 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 00";
label variable DVOOSR00 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 00";
label variable HHTOTD00 "# HOME HEALTH PROVIDER DAYS, 2000";
label variable HHAGD00 "# AGENCY HOME HEALTH PROVIDER DAYS 00";
label variable HHATCH00 "HOME HEALTH AGENCY VISIT CHARGES 00";
label variable HHAEXP00 "TOTAL HOME HEALTH AGENCY EXP 00";
label variable HHASLF00 "HOME HLTH AGENCY -SELF/FAMILY AMT 00";
label variable HHAMCR00 "HOME HLTH AGENCY -MEDICARE AMT 00";
label variable HHAMCD00 "HOME HLTH AGENCY -MEDICAID AMT 00";
label variable HHAPRV00 "HOME HLTH AGENCY -PRIVATE INS AMT 00";
label variable HHAVA00 "HOME HLTH AGENCY-VA AMT 00";
label variable HHATRI00 "HOME HLTH AGENCY-TRICARE AMT 00";
label variable HHAOFD00 "HOME HLTH AGENCY-OTHER FED AMT 00";
label variable HHASTL00 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 00";
label variable HHAWCP00 "HOME HLTH AGENCY- WORKERS COMP AMT 00";
label variable HHAOPR00 "HOME HLTH AGENCY - OTH PRIVATE AMT 00";
label variable HHAOPU00 "HOME HLTH AGENCY - OTH PUBLIC AMT 00";
label variable HHAOSR00 "H HLTH AGENCY - OT UNCLASS SRCE AMT 00";
label variable HHINDD00 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 00";
label variable HHNTCH00 "HOME HEALTH NON-AGENCY VISIT CHARGES 00";
label variable HHNEXP00 "TOTAL HOME HEALTH NON-AGNCY EXP 00";
label variable HHNSLF00 "HOME HLTH NON-AGNCY -SELF/FAM AMT 00";
label variable HHNMCR00 "HOME HLTH NON-AGNCY -MEDICARE AMT 00";
label variable HHNMCD00 "HOME HLTH NON-AGNCY -MEDICAID AMT 00";
label variable HHNPRV00 "HOME HLTH NON-AGNCY -PRIV INS AMT 00";
label variable HHNVA00 "HOME HLTH NON-AGNCY-VA AMT 00";
label variable HHNTRI00 "HOME HLTH NON-AGNCY-TRICARE AMT 00";
label variable HHNOFD00 "HOME HLTH NON-AGNCY-OTHR FED AMT 00";
label variable HHNSTL00 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 00";
label variable HHNWCP00 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 00";
label variable HHNOPR00 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 00";
label variable HHNOPU00 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 00";
label variable HHNOSR00 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 00";
label variable HHINFD00 "# INFORMAL HOME HEALTH PROVIDER DAYS 00";
label variable VISEXP00 "TOTAL GLASSES/CONTACT LENS EXP 00";
label variable VISTCH00 "GLASSES/CONTACT LENSES CHARGES 00";
label variable VISSLF00 "GLASSES/CNTCT LENSES -SELF/FAM AMT 00";
label variable VISMCR00 "GLASSES/CNTCT LENSES-MEDICARE AMT 00";
label variable VISMCD00 "GLASSES/CNTCT LENSES-MEDICAID AMT 00";
label variable VISPRV00 "GLASSES/CNTCT LENSES-PRIV INS AMT 00";
label variable VISVA00 "GLASSES/CNTCT LENSES-VA AMT 00";
label variable VISTRI00 "GLASSES/LENSES-TRICARE AMT 00";
label variable VISOFD00 "GLASSES/CNTCT LENSES-OTHR FED AMT 00";
label variable VISSTL00 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 00";
label variable VISWCP00 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 00";
label variable VISOPR00 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 00";
label variable VISOPU00 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 00";
label variable VISOSR00 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 00";
label variable OTHTCH00 "OTHER EQUP/SUPPLIES CHARGES 00";
label variable OTHEXP00 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 00";
label variable OTHSLF00 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 00";
label variable OTHMCR00 "OTHER EQUP/SUPPLIES-MEDICARE AMT 00";
label variable OTHMCD00 "OTHER EQUP/SUPPLIES-MEDICAID AMT 00";
label variable OTHPRV00 "OTHER EQUP/SUPPLIES-PRIV INS AMT 00";
label variable OTHVA00 "OTHER EQUP/SUPPLY-VA AMT 00";
label variable OTHTRI00 "OTHER EQUP/SUPPLY-TRICARE AMT 00";
label variable OTHOFD00 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 00";
label variable OTHSTL00 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 00";
label variable OTHWCP00 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 00";
label variable OTHOPR00 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 00";
label variable OTHOPU00 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 00";
label variable OTHOSR00 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 00";
label variable RXTOT00 "# PRESC MEDS INCL REFILLS 00";
label variable RXEXP00 "TOTAL RX-EXP 00";
label variable RXSLF00 "TOTAL RX-SELF/FAMILY AMT 00";
label variable RXMCR00 "TOTAL RX--MEDICARE AMT 00";
label variable RXMCD00 "TOTAL RX-MEDICAID AMT 00";
label variable RXPRV00 "TOTAL RX-PRIVATE INS AMT 00";
label variable RXVA00 "TOTAL RX-VA AMT 00";
label variable RXTRI00 "TOTAL RX-TRICARE AMT 00";
label variable RXOFD00 "TOTAL RX-OTHER FED AMT 00";
label variable RXSTL00 "TOTAL RX-OTHER ST/LOCAL AMT 00";
label variable RXWCP00 "TOTAL RX-WORKERS COMP AMT 00";
label variable RXOPR00 "TOTAL RX - OTH PRIVATE AMT 00";
label variable RXOPU00 "TOTAL RX - OTH PUBLIC AMT 00";
label variable RXOSR00 "TOT RX-OTH UNCLASS SRCE AMT 00";
label variable PERWT00F "FINAL PERSON WEIGHT, 2000";
label variable FAMWT00F "FINAL FAMILY WEIGHT, 2000";
label variable FAMWT00C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/00";
label variable SQPQW00F "FINAL SAQ-PAQ PERSON WEIGHT, 2000";
label variable DIABW00F "DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR00 "VARIANCE ESTIMATION STRATUM - 2000";
label variable VARPSU00 "VARIANCE ESTIMATION PSU - 2000";


*DEFINE VALUE LABELS FOR REPORTS;
label define H500001X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         1 "1 YES"
         2 "2 NO" ;

label define H500002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H500003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H500004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H500005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO PERFORM ACTIVITIES" ;

label define H500008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H500009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H500010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H500011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H500012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H500013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT ANXIOUS/DEPRESSED"
         2 "2 MODERATELY ANXIOUS/DEPRESSED"
         3 "3 EXTREMELY ANXIOUS/DEPRESSED" ;

label define H500014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H500018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H500019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BETTER"
         2 "2 MUCH THE SAME"
         3 "3 WORSE" ;

label define H500020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H500023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H500024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 CONFINED TO BED" ;

label define H500031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H500032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H500033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H500035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PAIN"
         2 "2 HAVE MODERATE PAIN"
         3 "3 HAVE EXTREME PAIN" ;

label define H500036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H500037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H500039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H500041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H500043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH"
         100 "100 BEST HEALTH" ;

label define H500046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO WASH/DRESS" ;

label define H500047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H500049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H500052X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500055X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H500056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500062X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         69 "$69" ;

label define H500063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500067X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         85 "$85" ;

label define H500068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500071X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10 - $10" ;

label define H500072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500082X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         362 "$362" ;

label define H500083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500084X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         120 "$120 - $120" ;

label define H500085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500091X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         105 "$105 - $105" ;

label define H500092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500094X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         37 "$37 - $37" ;

label define H500095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500097X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         320 "$320" ;

label define H500098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500099X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         50 "$50 - $50" ;

label define H500100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500101X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H500102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500124X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16 - $16" ;

label define H500125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500131X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         31 "$31 - $31" ;

label define H500132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500135X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500136X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500137X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H500138X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE APPOINTMENT"
         2 "2 JUST WALKS IN"
         3 "3 SOMETIMES APPOINTM,SOMETIMES WALKS IN" ;

label define H500139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500145X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR"
         2000 "2000 YEAR" ;

label define H500153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR"
         2000 "2000 YEAR" ;

label define H500154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR" ;

label define H500155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H500158X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H500159X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H500160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H500163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H500166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H500167X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H500168X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H500169X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500170X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H500171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED IN ATTENDANCE"
         2 "2 UNABLE TO ATTEND"
         3 "3 NEITHER" ;

label define H500173X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H500176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H500179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500181X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H500182X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H500183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H500184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500186X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500190X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500192X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H500193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H500195X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500197X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500198X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H500200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H500204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PARENT ADMINISTERED"
         2 "2 OTHER" ;

label define H500206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H500209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H500217X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H500218X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H500219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H500221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H500222X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H500223X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H500224X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H500225X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H500226X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500227X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500230X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H500231X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H500232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H500238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H500239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H500240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H500241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H500242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H500243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H500244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H500245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H500246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H500248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H500249X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500250X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H500255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H500257X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500258X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500259X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H500260X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H500261X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H500262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500263X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H500264X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500265X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500266X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500273X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H500274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H500275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DURING 2001"
         2 "2 DURING 2000"
         3 "3 DURING 1999"
         4 "4 BEFORE 1999"
         5 "5 NEVER" ;

label define H500281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500286X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1" ;

label define H500287X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500288X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500289X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500290X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500291X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500292X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500293X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500294X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500295X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500296X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500297X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500298X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500300X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         98 "$98 - $98" ;

label define H500301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500303X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         100 "$100" ;

label define H500304X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         135 "$135 - $135" ;

label define H500305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500306X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         31 "$31" ;

label define H500307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500309X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 - 1" ;

label define H500310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500311X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         98 "$98" ;

label define H500312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500313X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1200 "$1200" ;

label define H500314X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         374 "$374" ;

label define H500315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500330X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         98 "$98 - $98" ;

label define H500331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H500332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H500333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H500334X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H500335X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H500336X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H500337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H500338X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 NOT ELIG/NOT LINKED TO RESPONDING RU" ;

label define H500339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H500341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H500342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H500343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H500351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR"
         2000 "2000 YEAR" ;

label define H500352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1999 "1999 YEAR"
         2000 "2000 YEAR" ;

label define H500353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR" ;

label define H500354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR" ;

label define H500355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H500356X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H500357X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H500358X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H500359X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500360X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500361X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500362X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500363X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         150 "$150 - $150" ;

label define H500364X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500365X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500366X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         62 "$62 - $62" ;

label define H500367X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500368X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500369X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500370X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500371X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500373X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500374X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500376X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500377X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500378X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500379X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500380X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500381X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500382X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500383X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500384X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500385X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500386X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500387X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500388X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500390X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500391X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500392X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H500394X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H500395X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H500396X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H500397X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H500398X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H500399X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H500400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500401X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H500402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H500404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H500405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H500406X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H500407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H500414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H500415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H500416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H500417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H500418X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE/IS DRIVEN"
         2 "2 TAXI,BUS,TRAIN,OTHER PUBLIC TRANSPORT"
         3 "3 WALKS"
         91 "91 OTHER WAY" ;

label define H500419X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500421X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H500422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500425X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H500426X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500436X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500437X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500438X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500439X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500440X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500441X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500442X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         871 "$871 - $871" ;

label define H500443X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         677 "$677" ;

label define H500444X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500445X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500446X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500447X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500448X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2000 "$2000" ;

label define H500449X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         31 "$31 - $31" ;

label define H500450X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500452X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500455X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         307 "$307 - $307" ;

label define H500456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500457X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         40 "$40" ;

label define H500458X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500459X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         35 "$35 - $35" ;

label define H500460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500461X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500462X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         921 "$921 - $921" ;

label define H500463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500465X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         240 "$240 - $240"
         2565 "$2566 - $2565" ;

label define H500466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500468X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500469X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H500470X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H500471X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN"
         3 "3 MEXICAN/MEXICAN AMERI/MEXICANO/CHICANO"
         4 "4 OTHER LATIN AMERICAN/OTHER SPANISH"
         5 "5 NON-HISPANIC"
         91 "91 OTHER HISPANIC/LATINO" ;

label define H500472X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H500473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500475X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500476X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500549X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H500550X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H500551X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H500552X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $57.69"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500553X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $57.69"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500554X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $57.69"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500555X
         0 "0 NO"
         1 "1 YES" ;

label define H500556X
         0 "0 NO"
         1 "1 YES" ;

label define H500557X
         0 "0 NO"
         1 "1 YES" ;

label define H500558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500574X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2000"
         2 "2 NOT IN-SCOPE ON 12/31/2000" ;

label define H500575X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/00"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H500576X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/00"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H500577X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/00"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H500578X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/00"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H500579X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2000"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2000" ;

label define H500580X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H500581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500582X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500583X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500585X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500589X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500590X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500594X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500596X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500597X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500598X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500600X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H500601X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500602X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500603X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500604X
         -1 "-1 INAPPLICABLE"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H500605X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500608X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500610X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500612X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         12 "$12 - $12" ;

label define H500613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500636X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H500637X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500639X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500640X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H500641X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H500642X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H500643X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H500644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500645X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500646X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H500647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500648X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H500652X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500655X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H500656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500657X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSP, NOT ER"
         3 "3 HOSP, ER" ;

label define H500658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500659X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DIFFERENT LANGUAGE"
         11 "11 HARD TO GET INTO BUILDING"
         13 "13 NO APPROPRIATE EQUIPMENT IN OFFICE"
         14 "14 COULD NOT GET TIME OFF WORK"
         15 "15 DK WHERE TO GO TO GET CARE"
         16 "16 WAS REFUSED SERVICES"
         17 "17 COULDN'T GET CHILD CARE"
         18 "18 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 PRE-EXISTING CONDITION"
         4 "4 INS CO REQUIRED REFERRL-COULD NOT GET"
         5 "5 DOCTOR REFUSED FAMILY INS PLAN"
         6 "6 MEDICAL CARE TOO FAR AWAY"
         7 "7 CAN NOT DRIVE/NO CAR/NO PUBLIC TRANSP"
         8 "8 TOO EXPENSIVE TO GET THERE"
         9 "9 HEARING IMPAIRMENT OR LOSS"
         91 "91 OTHER" ;

label define H500660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H500661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H500662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H500663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H500664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H500665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500691X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500694X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICAID - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID HMO"
         2 "2 COV BY MEDICAID - NOT HMO"
         3 "3 NOT COV BY MEDICAID" ;

label define H500695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICAID - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID HMO"
         2 "2 COV BY MEDICAID - NOT HMO"
         3 "3 NOT COV BY MEDICAID" ;

label define H500696X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICAID - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID HMO"
         2 "2 COV BY MEDICAID - NOT HMO"
         3 "3 NOT COV BY MEDICAID" ;

label define H500697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500705X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICAID-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID" ;

label define H500706X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICAID-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID" ;

label define H500707X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICAID-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID" ;

label define H500708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500722X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H500746X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H500749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H500750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H500751X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H500752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H500753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H500754X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500759X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500760X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500761X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H500763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H500764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H500765X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H500766X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H500767X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H500768X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H500769X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500770X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H500771X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500772X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500773X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500774X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500776X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500777X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500778X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H500779X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500780X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500781X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500782X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H500784X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H500786X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500787X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500788X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H500789X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H500790X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H500791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H500792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H500793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500794X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500795X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500796X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500797X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500798X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         69 "$69" ;

label define H500799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500802X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500803X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         85 "$85" ;

label define H500804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500806X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500807X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10 - $10" ;

label define H500808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500809X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500811X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500813X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500814X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500815X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500818X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         362 "$362" ;

label define H500819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500820X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         120 "$120 - $120" ;

label define H500821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500824X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500831X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 - 1" ;

label define H500832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500835X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500841X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         105 "$105 - $105" ;

label define H500842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500844X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         37 "$37 - $37" ;

label define H500845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500847X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         320 "$320" ;

label define H500848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500849X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         50 "$50 - $50" ;

label define H500850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500851X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H500852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500861X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500863X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500865X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500867X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500869X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500870X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500871X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500872X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500874X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500875X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500876X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500878X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500879X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 - 1" ;

label define H500880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500881X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500882X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500883X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500884X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500885X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500886X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500887X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500888X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         31 "$31 - $31" ;

label define H500889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500890X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         52 "$52" ;

label define H500891X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500892X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 - 1" ;

label define H500893X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500894X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500895X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         51 "$51 - $51" ;

label define H500896X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500897X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         31 "$31 - $31" ;

label define H500898X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500899X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500900X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500902X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500903X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500904X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500905X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500906X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500907X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500908X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500909X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500910X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500911X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500912X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500913X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500914X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H500915X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500916X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500917X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500918X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500919X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500920X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500921X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500925X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500938X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H500939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H500948X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500949X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500950X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500951X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500952X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500953X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500954X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500955X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500956X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500957X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500958X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         98 "$98 - $98" ;

label define H500959X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500960X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         19 "$19 - $19" ;

label define H500961X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500962X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500963X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500964X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500965X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500966X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500967X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500968X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500969X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500970X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500971X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500972X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500973X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500974X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500977X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500978X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500979X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500985X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H500999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501001X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         216 "$216" ;

label define H501002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501004X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501005X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501007X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501008X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501009X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501010X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501011X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501012X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501015X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         98 "$98 - $98" ;

label define H501016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501020X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1"
         2 "2" ;

label define H501021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501022X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H501036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H501037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H501038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501039X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501040X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501046X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         480 "$480" ;

label define H501047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501048X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         7 "$7 - $7" ;

label define H501049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501051X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501052X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501054X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501056X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         35 "$35" ;

label define H501057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501059X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         436 "$436 - $436" ;

label define H501060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501066X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501067X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501068X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501069X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501070X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501071X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501072X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501073X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501074X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501078X
         4 "4 PANEL 4"
         5 "5 PANEL 5" ;

label define H501079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H501080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501081X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501082X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501084X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501085X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501099X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501100X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501111X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H501112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501113X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501114X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H501115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501120X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501121X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501122X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501128X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501144X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501147X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501148X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501158X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H501159X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501161X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501165X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501166X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501167X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501168X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501169X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501170X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501171X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501172X
         -1 "-1 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501173X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501174X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501175X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501176X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501177X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501202X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501204X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501205X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501207X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H501208X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROV" ;

label define H501209X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H501210X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H501211X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H501212X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H501213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501214X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501220X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501221X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501226X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H501227X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H501228X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H501229X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H501230X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H501231X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H501232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H501233X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H501234X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H501235X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H501236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501243X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501244X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501245X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501246X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501249X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501250X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501252X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501255X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501259X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501260X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK/NOT HISPANIC"
         3 "3 OTHER" ;

label define H501261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AMERICAN INDIAN"
         2 "2 ALEUT, ESKIMO"
         3 "3 ASIAN OR PACIFIC ISLANDER"
         4 "4 BLACK"
         5 "5 WHITE"
         91 "91 OTHER" ;

label define H501262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H501263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H501264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501269X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501270X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501271X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501272X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501273X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H501274X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H501275X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H501276X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H501277X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H501278X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H501279X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H501280X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H501281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501282X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501283X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H501285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H501286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H501287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H501288X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H501289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H501290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H501291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H501292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H501293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H501294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H501295X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H501296X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H501297X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H501298X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H501299X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H501300X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H501301X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H501302X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H501303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501317X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H501319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H501322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H501326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501327X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501329X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501330X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H501332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO"
         1 "1 YES" ;

label define H501333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501334X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501335X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H501337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501338X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501339X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, SPECIAL PROGRAM"
         2 "2 YES, EARLY INTERVENTION SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H501344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, ENROLLED IN SPECIAL EDUCATION"
         2 "2 YES, RELATED SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H501346X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H501347X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H501348X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H501349X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H501350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H501351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H501352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H501353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H501354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H501355X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H501356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABLILITY"
         2 "2 SOME OTHER REASON" ;

label define H501359X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501378X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501379X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H501381X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H501382X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H501383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501384X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501385X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H501387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H501388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501390X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H501391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H501392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501397X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH" ;

label define H501398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORAM 1040EZ"
         91 "91 OTHER" ;

label define H501399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501400X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501401X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501402X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501403X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501404X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501405X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501406X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501407X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501408X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501409X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501410X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501411X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501412X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501413X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H501415X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H501437X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501439X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501440X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MD-GEN/FAM PRACTICE"
         10 "10 OTHER NON-MD PROVIDR"
         11 "11 UNKNOWN"
         2 "2 MD-INTERNAL MEDICINE"
         3 "3 MD-PEDIATRICS"
         4 "4 MD-OB/GYN"
         5 "5 MD-SURGERY"
         6 "6 MD-OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE/NURSE PRACTNR"
         9 "9 PHYSICIAN'S ASST" ;

label define H501441X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSP CLINIC/OUTPUT DEPT"
         2 "2 PRIV OFF IN HOSP"
         3 "3 HOSP ER"
         4 "4 NON-HOSP" ;

label define H501442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501444X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501445X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H501448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501450X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501451X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501452X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501453X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H501454X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H501456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H501457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501458X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H501459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H501460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501461X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H501462X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501472X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         60 "$60 - $60" ;

label define H501473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501474X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         144 "$144 - $144" ;

label define H501475X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H501476X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501477X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501478X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 5 MIN"
         2 "2 5 TO 15 MINUTES"
         3 "3 16 TO 30 MINUTES"
         4 "4 31 TO 59 MINUTES"
         5 "5 1 TO 2 HOURS"
         6 "6 MORE THAN 2 HOURS" ;

label define H501479X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501481X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501484X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501487X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501489X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501492X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H501493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501494X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 79 POUNDS"
         10 "10 240 TO 259 POUNDS"
         11 "11 260 TO 279 POUNDS"
         12 "12 280 TO 299 POUNDS"
         13 "13 300 TO 319 POUNDS"
         2 "2 80 TO 99 POUNDS"
         3 "3 100 TO 119 POUNDS"
         4 "4 120 TO 139 POUNDS"
         5 "5 140 TO 159 POUNDS"
         6 "6 160 TO 179 POUNDS"
         7 "7 180 TO 199 POUNDS"
         8 "8 200 TO 219 POUNDS"
         9 "9 220 TO 239 POUNDS" ;

label define H501495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501496X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H501497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H501498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H501499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RELATIVE"
         2 "2 NON-RELATIVE" ;

label define H501500X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CHILD'S HOME"
         2 "2 OTHER PRIVATE HOME"
         3 "3 NURSERY, PRESCHOOL"
         4 "4 ORG (BEFORE/AFTER) SCHOOL ACTIVITIES"
         5 "5 DAY CARE CENTER, NOT AT PARENT'S WORK"
         6 "6 DAY CARE CENTER, AT PARENT'S WORKPLACE"
         7 "7 PARENT WATCHES CHILD AT WORK"
         91 "91 SOME OTHER ARRANGEMENT" ;

label define H501501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501503X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501504X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H501506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H501507X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501509X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501510X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H501512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H501513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H501514X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INS PLAN"
         10 "10 JOB RELATED REASON"
         11 "11 NEW DOC REF/RECOM"
         12 "12 OTH COMPLNT OLD DOC"
         13 "13 TRANSPORTATION"
         2 "2 INSUR PLAN CHNG DOCS"
         3 "3 DISSATIS W/QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHNGD"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 OTHER INSUR-RELATED REASON"
         91 "91 OTHER REASON" ;

label define H501515X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PREFERS/LIKES THIS USC"
         10 "10 INSURANCE RELATED REASON"
         2 "2 DK WHERE ELSE TO GO"
         3 "3 CANT AFFORD GO ELSEWHERE"
         4 "4 OWN DOC HAS OFFICE HERE"
         5 "5 ONLY CARE AVAIL WHEN TIME"
         6 "6 CONVENIENCE"
         7 "7 BEST FOR MY CONDITION"
         8 "8 MILITARY/VA"
         91 "91 OTHER REASON" ;

label define H501516X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INSUR PLAN"
         10 "10 OTH INSUR-RELATED REASON"
         2 "2 INSURANCE PLAN CHANGED DOCTORS IT COVERS"
         3 "3 DISSATIS W/ QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHANGED"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 SELDOM SICK/NO NEED"
         91 "91 OTHER REASON" ;

label define H501517X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 OTHER INSUR-RELATED REAS"
         2 "2 RECENTLY MOVED TO AREA"
         3 "3 DONT KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         6 "6 GOES DIFF PL FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSUR PLANS"
         8 "8 DONT USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H501518X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501519X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501520X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501521X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501522X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501523X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         507 "$507 - $507" ;

label define H501524X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501525X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501526X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501527X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501528X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501529X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         855 "$855" ;

label define H501530X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1161 "$1161" ;

label define H501531X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1919 "$1919 - $1919" ;

label define H501532X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501533X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501534X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501535X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         5225 "$5225" ;

label define H501536X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501537X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         8857 "$8857" ;

label define H501538X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501539X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501540X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501541X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         363 "$363" ;

label define H501542X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H501543X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3001 "$3001" ;

label define H501544X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         111 "$111 - $111" ;

label define H501545X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         46 "$46 - $46" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H500001X;
label value ACTDTY31 H500002X;
label value ACTDTY42 H500003X;
label value ACTDTY53 H500004X;
label value ACTLIM31 H500005X;
label value ACTLIM53 H500006X;
label value ADACTI42 H500007X;
label value ADAPPT42 H500008X;
label value ADBLUE42 H500009X;
label value ADCALM42 H500010X;
label value ADCLIM42 H500011X;
label value ADDAYA42 H500012X;
label value ADDEPR42 H500013X;
label value ADDRBP42 H500014X;
label value ADDSMK42 H500015X;
label value ADEXPL42 H500016X;
label value ADGENH42 H500017X;
label value ADHECR42 H500018X;
label value ADHLTH42 H500019X;
label value ADILCR42 H500020X;
label value ADILWW42 H500021X;
label value ADINSA42 H500022X;
label value ADINSB42 H500023X;
label value ADLHLP31 H500024X;
label value ADLHLP42 H500025X;
label value ADLHLP53 H500026X;
label value ADLIST42 H500027X;
label value ADMACC42 H500028X;
label value ADMLMT42 H500029X;
label value ADMOBI42 H500030X;
label value ADNECR42 H500031X;
label value ADOVER42 H500032X;
label value ADPACC42 H500033X;
label value ADPAIN42 H500034X;
label value ADPAYN42 H500035X;
label value ADPEP42 H500036X;
label value ADPLMT42 H500037X;
label value ADPRRE42 H500038X;
label value ADPRTM42 H500039X;
label value ADPRX42 H500040X;
label value ADRESP42 H500041X;
label value ADRISK42 H500042X;
label value ADRTCR42 H500043X;
label value ADRTWW42 H500044X;
label value ADSCAL42 H500045X;
label value ADSELF42 H500046X;
label value ADSMOK42 H500047X;
label value ADSOCA42 H500048X;
label value ADSPEC42 H500049X;
label value ADUPRO42 H500050X;
label value AFDC00 H500051X;
label value AFFORD42 H500052X;
label value AIDHLP31 H500053X;
label value AIDHLP53 H500054X;
label value ALIIMP00 H500055X;
label value ALIMP00X H500056X;
label value AMAEXP00 H500057X;
label value AMAMCD00 H500058X;
label value AMAMCR00 H500059X;
label value AMAOFD00 H500060X;
label value AMAOPR00 H500061X;
label value AMAOPU00 H500062X;
label value AMAOSR00 H500063X;
label value AMAPRV00 H500064X;
label value AMASLF00 H500065X;
label value AMASST00 H500066X;
label value AMASTL00 H500067X;
label value AMATCH00 H500068X;
label value AMATRI00 H500069X;
label value AMAVA00 H500070X;
label value AMAWCP00 H500071X;
label value AMCEXP00 H500072X;
label value AMCHIR00 H500073X;
label value AMCMCD00 H500074X;
label value AMCMCR00 H500075X;
label value AMCOFD00 H500076X;
label value AMCOPR00 H500077X;
label value AMCOPU00 H500078X;
label value AMCOSR00 H500079X;
label value AMCPRV00 H500080X;
label value AMCSLF00 H500081X;
label value AMCSTL00 H500082X;
label value AMCTCH00 H500083X;
label value AMCTRI00 H500084X;
label value AMCVA00 H500085X;
label value AMCWCP00 H500086X;
label value AMDRC00 H500087X;
label value AMEEXP00 H500088X;
label value AMEMCD00 H500089X;
label value AMEMCR00 H500090X;
label value AMEOFD00 H500091X;
label value AMEOPR00 H500092X;
label value AMEOPU00 H500093X;
label value AMEOSR00 H500094X;
label value AMEPRV00 H500095X;
label value AMESLF00 H500096X;
label value AMESTL00 H500097X;
label value AMETCH00 H500098X;
label value AMETRI00 H500099X;
label value AMEVA00 H500100X;
label value AMEWCP00 H500101X;
label value AMNEXP00 H500102X;
label value AMNMCD00 H500103X;
label value AMNMCR00 H500104X;
label value AMNOFD00 H500105X;
label value AMNOPR00 H500106X;
label value AMNOPU00 H500107X;
label value AMNOSR00 H500108X;
label value AMNPRV00 H500109X;
label value AMNSLF00 H500110X;
label value AMNSTL00 H500111X;
label value AMNTCH00 H500112X;
label value AMNTRI00 H500113X;
label value AMNURS00 H500114X;
label value AMNVA00 H500115X;
label value AMNWCP00 H500116X;
label value AMOPTO00 H500117X;
label value AMTEXP00 H500118X;
label value AMTHER00 H500119X;
label value AMTMCD00 H500120X;
label value AMTMCR00 H500121X;
label value AMTOFD00 H500122X;
label value AMTOPR00 H500123X;
label value AMTOPU00 H500124X;
label value AMTOSR00 H500125X;
label value AMTOTC00 H500126X;
label value AMTPRV00 H500127X;
label value AMTSLF00 H500128X;
label value AMTSTL00 H500129X;
label value AMTTCH00 H500130X;
label value AMTTRI00 H500131X;
label value AMTVA00 H500132X;
label value AMTWCP00 H500133X;
label value ANGIDX53 H500134X;
label value ANYLIM00 H500135X;
label value ANYUSC42 H500136X;
label value APPDIF42 H500137X;
label value APPTWL42 H500138X;
label value ASATAK53 H500139X;
label value ASFLOW53 H500140X;
label value ASMED53 H500141X;
label value ASPRIN53 H500142X;
label value ASSTER53 H500143X;
label value ASTHDX53 H500144X;
label value AVAILT42 H500145X;
label value BEGRFD31 H500146X;
label value BEGRFD42 H500147X;
label value BEGRFD53 H500148X;
label value BEGRFM31 H500149X;
label value BEGRFM42 H500150X;
label value BEGRFM53 H500151X;
label value BEGRFY31 H500152X;
label value BEGRFY42 H500153X;
label value BEGRFY53 H500154X;
label value BENDIF31 H500155X;
label value BENDIF53 H500156X;
label value BGNWK31 H500157X;
label value BGNWK42 H500158X;
label value BGNWK53 H500159X;
label value BLIND42 H500160X;
label value BOWEL53 H500161X;
label value BPCHEK53 H500162X;
label value BPMLDX53 H500163X;
label value BPMONT53 H500164X;
label value BRSTEX53 H500165X;
label value BSNTY31 H500166X;
label value BSNTY42 H500167X;
label value BSNTY53 H500168X;
label value BSTPLA42 H500169X;
label value BUSIMP00 H500170X;
label value CANTPL42 H500171X;
label value CANTSC42 H500172X;
label value CARECO42 H500173X;
label value CASHP00X H500174X;
label value CHAPPT42 H500175X;
label value CHCOUN42 H500176X;
label value CHDDX53 H500177X;
label value CHECK53 H500178X;
label value CHEMPB42 H500179X;
label value CHEXPL42 H500180X;
label value CHGJ3142 H500181X;
label value CHGJ4253 H500182X;
label value CHHECR42 H500183X;
label value CHILCR42 H500184X;
label value CHILWW42 H500185X;
label value CHLDCA42 H500186X;
label value CHLDP00X H500187X;
label value CHLICO42 H500188X;
label value CHLIHB42 H500189X;
label value CHLIM42 H500190X;
label value CHLIMI42 H500191X;
label value CHLIMP00 H500192X;
label value CHLIST42 H500193X;
label value CHNECR42 H500194X;
label value CHNGUS42 H500195X;
label value CHOIC31 H500196X;
label value CHOIC42 H500197X;
label value CHOIC53 H500198X;
label value CHOLCK53 H500199X;
label value CHPMCN42 H500200X;
label value CHPMED42 H500201X;
label value CHPMHB42 H500202X;
label value CHPRRE42 H500203X;
label value CHPRTM42 H500204X;
label value CHPRX42 H500205X;
label value CHRESP42 H500206X;
label value CHRTCR42 H500207X;
label value CHRTWW42 H500208X;
label value CHSERV42 H500209X;
label value CHSPEC42 H500210X;
label value CHSRCN42 H500211X;
label value CHSRHB42 H500212X;
label value CHTHCO42 H500213X;
label value CHTHER42 H500214X;
label value CHTHHB42 H500215X;
label value CIND31 H500216X;
label value CIND42 H500217X;
label value CIND53 H500218X;
label value CLMDEP00 H500219X;
label value CLMHIP00 H500220X;
label value COCCP31 H500221X;
label value COCCP42 H500222X;
label value COCCP53 H500223X;
label value COGLIM31 H500224X;
label value COGLIM53 H500225X;
label value CONFID42 H500226X;
label value CONVEN42 H500227X;
label value COVRMM H500228X;
label value COVRYY H500229X;
label value CSHCN42 H500230X;
label value CSHIMP00 H500231X;
label value DADPRO42 H500232X;
label value DAPID31X H500233X;
label value DAPID42X H500234X;
label value DAPID53X H500235X;
label value DAYCAR00 H500236X;
label value DDBDYS31 H500237X;
label value DDBDYS42 H500238X;
label value DDBDYS53 H500239X;
label value DDNSCL31 H500240X;
label value DDNSCL42 H500241X;
label value DDNSCL53 H500242X;
label value DDNWRK31 H500243X;
label value DDNWRK42 H500244X;
label value DDNWRK53 H500245X;
label value DEAF42 H500246X;
label value DEDUCT00 H500247X;
label value DENTCK53 H500248X;
label value DENTIN31 H500249X;
label value DENTIN42 H500250X;
label value DENTIN53 H500251X;
label value DENYINSR H500252X;
label value DENYOTH H500253X;
label value DEPDNT00 H500254X;
label value DIABDX53 H500255X;
label value DIDSERVE H500256X;
label value DIFFPL42 H500257X;
label value DISTAN42 H500258X;
label value DISVW31X H500259X;
label value DISVW42X H500260X;
label value DISVW53X H500261X;
label value DIVDP00X H500262X;
label value DIVIMP00 H500263X;
label value DKELSE42 H500264X;
label value DKWHER42 H500265X;
label value DKWHRU42 H500266X;
label value DNYCANC H500267X;
label value DNYCORON H500268X;
label value DNYDIAB H500269X;
label value DNYHYPER H500270X;
label value DOBMM H500271X;
label value DOBYY H500272X;
label value DPINRU00 H500273X;
label value DPOTSD00 H500274X;
label value DPTSHT42 H500275X;
label value DSA1C53 H500276X;
label value DSCKFT53 H500277X;
label value DSDIA53 H500278X;
label value DSDIET53 H500279X;
label value DSEYE53 H500280X;
label value DSEYPR53 H500281X;
label value DSINSU53 H500282X;
label value DSKIDN53 H500283X;
label value DSMED53 H500284X;
label value DSPRX53 H500285X;
label value DVGEN00 H500286X;
label value DVGEXP00 H500287X;
label value DVGMCD00 H500288X;
label value DVGMCR00 H500289X;
label value DVGOFD00 H500290X;
label value DVGOPR00 H500291X;
label value DVGOPU00 H500292X;
label value DVGOSR00 H500293X;
label value DVGPRV00 H500294X;
label value DVGSLF00 H500295X;
label value DVGSTL00 H500296X;
label value DVGTCH00 H500297X;
label value DVGTRI00 H500298X;
label value DVGVA00 H500299X;
label value DVGWCP00 H500300X;
label value DVOEXP00 H500301X;
label value DVOMCD00 H500302X;
label value DVOMCR00 H500303X;
label value DVOOFD00 H500304X;
label value DVOOPR00 H500305X;
label value DVOOPU00 H500306X;
label value DVOOSR00 H500307X;
label value DVOPRV00 H500308X;
label value DVORTH00 H500309X;
label value DVOSLF00 H500310X;
label value DVOSTL00 H500311X;
label value DVOTCH00 H500312X;
label value DVOTRI00 H500313X;
label value DVOVA00 H500314X;
label value DVOWCP00 H500315X;
label value DVTEXP00 H500316X;
label value DVTMCD00 H500317X;
label value DVTMCR00 H500318X;
label value DVTOFD00 H500319X;
label value DVTOPR00 H500320X;
label value DVTOPU00 H500321X;
label value DVTOSR00 H500322X;
label value DVTOT00 H500323X;
label value DVTPRV00 H500324X;
label value DVTSLF00 H500325X;
label value DVTSTL00 H500326X;
label value DVTTCH00 H500327X;
label value DVTTRI00 H500328X;
label value DVTVA00 H500329X;
label value DVTWCP00 H500330X;
label value EDUCYEAR H500331X;
label value EICRDT00 H500332X;
label value ELDISC00 H500333X;
label value ELGRND00 H500334X;
label value ELGRND31 H500335X;
label value ELGRND42 H500336X;
label value ELGRND53 H500337X;
label value ELIGIBLE H500338X;
label value EMPHDX53 H500339X;
label value EMPST31 H500340X;
label value EMPST42 H500341X;
label value EMPST53 H500342X;
label value ENDRFD00 H500343X;
label value ENDRFD31 H500344X;
label value ENDRFD42 H500345X;
label value ENDRFD53 H500346X;
label value ENDRFM00 H500347X;
label value ENDRFM31 H500348X;
label value ENDRFM42 H500349X;
label value ENDRFM53 H500350X;
label value ENDRFY00 H500351X;
label value ENDRFY31 H500352X;
label value ENDRFY42 H500353X;
label value ENDRFY53 H500354X;
label value ENDWK31 H500355X;
label value ENDWK42 H500356X;
label value ENDWK53 H500357X;
label value EQU42 H500358X;
label value EQUIPM42 H500359X;
label value ERDEXP00 H500360X;
label value ERDMCD00 H500361X;
label value ERDMCR00 H500362X;
label value ERDOFD00 H500363X;
label value ERDOPR00 H500364X;
label value ERDOPU00 H500365X;
label value ERDOSR00 H500366X;
label value ERDPRV00 H500367X;
label value ERDSLF00 H500368X;
label value ERDSTL00 H500369X;
label value ERDTCH00 H500370X;
label value ERDTRI00 H500371X;
label value ERDVA00 H500372X;
label value ERDWCP00 H500373X;
label value ERFEXP00 H500374X;
label value ERFMCD00 H500375X;
label value ERFMCR00 H500376X;
label value ERFOFD00 H500377X;
label value ERFOPR00 H500378X;
label value ERFOPU00 H500379X;
label value ERFOSR00 H500380X;
label value ERFPRV00 H500381X;
label value ERFSLF00 H500382X;
label value ERFSTL00 H500383X;
label value ERFTCH00 H500384X;
label value ERFTRI00 H500385X;
label value ERFVA00 H500386X;
label value ERFWCP00 H500387X;
label value ERTOT00 H500388X;
label value EVRETIRE H500389X;
label value EVRWRK H500390X;
label value EXPENS42 H500391X;
label value EXRCIS53 H500392X;
label value FAMCNS42 H500393X;
label value FAMRFPYR H500394X;
label value FAMSZE00 H500395X;
label value FAMSZE31 H500396X;
label value FAMSZE42 H500397X;
label value FAMSZE53 H500398X;
label value FARIMP00 H500399X;
label value FARMP00X H500400X;
label value FCRP1231 H500401X;
label value FILEDR00 H500402X;
label value FILER00 H500403X;
label value FLSTAT00 H500404X;
label value FLUSHT53 H500405X;
label value FMRS1231 H500406X;
label value FNGRDF31 H500407X;
label value FNGRDF53 H500408X;
label value FOODCT00 H500409X;
label value FOODMN00 H500410X;
label value FOODST00 H500411X;
label value FOODVL00 H500412X;
label value FTSTU00X H500413X;
label value FTSTU31X H500414X;
label value FTSTU42X H500415X;
label value FTSTU53X H500416X;
label value GETSIC42 H500417X;
label value GETTOU42 H500418X;
label value HAVEUS42 H500419X;
label value HAVFUN42 H500420X;
label value HCNEED42 H500421X;
label value HEARAD42 H500422X;
label value HEARDI42 H500423X;
label value HEARMO42 H500424X;
label value HEARNG42 H500425X;
label value HEARPR42 H500426X;
label value HEARSM42 H500427X;
label value HELD31X H500428X;
label value HELD42X H500429X;
label value HELD53X H500430X;
label value HEPSHT42 H500431X;
label value HGHTFT53 H500432X;
label value HGHTIN53 H500433X;
label value HGTFT42 H500434X;
label value HGTIN42 H500435X;
label value HHAEXP00 H500436X;
label value HHAGD00 H500437X;
label value HHAMCD00 H500438X;
label value HHAMCR00 H500439X;
label value HHAOFD00 H500440X;
label value HHAOPR00 H500441X;
label value HHAOPU00 H500442X;
label value HHAOSR00 H500443X;
label value HHAPRV00 H500444X;
label value HHASLF00 H500445X;
label value HHASTL00 H500446X;
label value HHATCH00 H500447X;
label value HHATRI00 H500448X;
label value HHAVA00 H500449X;
label value HHAWCP00 H500450X;
label value HHINDD00 H500451X;
label value HHINFD00 H500452X;
label value HHNEXP00 H500453X;
label value HHNMCD00 H500454X;
label value HHNMCR00 H500455X;
label value HHNOFD00 H500456X;
label value HHNOPR00 H500457X;
label value HHNOPU00 H500458X;
label value HHNOSR00 H500459X;
label value HHNPRV00 H500460X;
label value HHNSLF00 H500461X;
label value HHNSTL00 H500462X;
label value HHNTCH00 H500463X;
label value HHNTRI00 H500464X;
label value HHNVA00 H500465X;
label value HHNWCP00 H500466X;
label value HHTOTD00 H500467X;
label value HIBPDX53 H500468X;
label value HIDEGYR H500469X;
label value HISPANX H500470X;
label value HISPCAT H500471X;
label value HLTHY42 H500472X;
label value HOMEBH42 H500473X;
label value HOUR31 H500474X;
label value HOUR42 H500475X;
label value HOUR53 H500476X;
label value HPDAP00 H500477X;
label value HPDAU00 H500478X;
label value HPDDE00 H500479X;
label value HPDFE00 H500480X;
label value HPDJA00 H500481X;
label value HPDJL00 H500482X;
label value HPDJU00 H500483X;
label value HPDMA00 H500484X;
label value HPDMY00 H500485X;
label value HPDNO00 H500486X;
label value HPDOC00 H500487X;
label value HPDSE00 H500488X;
label value HPEAP00 H500489X;
label value HPEAU00 H500490X;
label value HPEDE00 H500491X;
label value HPEFE00 H500492X;
label value HPEJA00 H500493X;
label value HPEJL00 H500494X;
label value HPEJU00 H500495X;
label value HPEMA00 H500496X;
label value HPEMY00 H500497X;
label value HPENO00 H500498X;
label value HPEOC00 H500499X;
label value HPESE00 H500500X;
label value HPNAP00 H500501X;
label value HPNAU00 H500502X;
label value HPNDE00 H500503X;
label value HPNFE00 H500504X;
label value HPNJA00 H500505X;
label value HPNJL00 H500506X;
label value HPNJU00 H500507X;
label value HPNMA00 H500508X;
label value HPNMY00 H500509X;
label value HPNNO00 H500510X;
label value HPNOC00 H500511X;
label value HPNSE00 H500512X;
label value HPOAP00 H500513X;
label value HPOAU00 H500514X;
label value HPODE00 H500515X;
label value HPOFE00 H500516X;
label value HPOJA00 H500517X;
label value HPOJL00 H500518X;
label value HPOJU00 H500519X;
label value HPOMA00 H500520X;
label value HPOMY00 H500521X;
label value HPONO00 H500522X;
label value HPOOC00 H500523X;
label value HPOSE00 H500524X;
label value HPRAP00 H500525X;
label value HPRAU00 H500526X;
label value HPRDE00 H500527X;
label value HPRFE00 H500528X;
label value HPRJA00 H500529X;
label value HPRJL00 H500530X;
label value HPRJU00 H500531X;
label value HPRMA00 H500532X;
label value HPRMY00 H500533X;
label value HPRNO00 H500534X;
label value HPROC00 H500535X;
label value HPRSE00 H500536X;
label value HPSAP00 H500537X;
label value HPSAU00 H500538X;
label value HPSDE00 H500539X;
label value HPSFE00 H500540X;
label value HPSJA00 H500541X;
label value HPSJL00 H500542X;
label value HPSJU00 H500543X;
label value HPSMA00 H500544X;
label value HPSMY00 H500545X;
label value HPSNO00 H500546X;
label value HPSOC00 H500547X;
label value HPSSE00 H500548X;
label value HRHOW31 H500549X;
label value HRHOW42 H500550X;
label value HRHOW53 H500551X;
label value HRWG31X H500552X;
label value HRWG42X H500553X;
label value HRWG53X H500554X;
label value HRWGIM31 H500555X;
label value HRWGIM42 H500556X;
label value HRWGIM53 H500557X;
label value HSELIM31 H500558X;
label value HSELIM53 H500559X;
label value HYSTER53 H500560X;
label value IADLHP31 H500561X;
label value IADLHP42 H500562X;
label value IADLHP53 H500563X;
label value INS00X H500564X;
label value INS31X H500565X;
label value INS42X H500566X;
label value INS53X H500567X;
label value INSAP00X H500568X;
label value INSAT00X H500569X;
label value INSAT31X H500570X;
label value INSAT42X H500571X;
label value INSAT53X H500572X;
label value INSAU00X H500573X;
label value INSC1231 H500574X;
label value INSCOP00 H500575X;
label value INSCOP31 H500576X;
label value INSCOP42 H500577X;
label value INSCOP53 H500578X;
label value INSCOPE H500579X;
label value INSCOV00 H500580X;
label value INSDE00X H500581X;
label value INSENDMM H500582X;
label value INSENDYY H500583X;
label value INSFE00X H500584X;
label value INSIDE42 H500585X;
label value INSJA00X H500586X;
label value INSJL00X H500587X;
label value INSJU00X H500588X;
label value INSLIMIT H500589X;
label value INSLOOK H500590X;
label value INSMA00X H500591X;
label value INSMY00X H500592X;
label value INSNO00X H500593X;
label value INSNOP42 H500594X;
label value INSOC00X H500595X;
label value INSREA42 H500596X;
label value INSRPL42 H500597X;
label value INSRQR42 H500598X;
label value INSSE00X H500599X;
label value INTIMP00 H500600X;
label value INTOBL42 H500601X;
label value INTRP00X H500602X;
label value INTRTX00 H500603X;
label value INTVLANG H500604X;
label value IPDEXP00 H500605X;
label value IPDIS00 H500606X;
label value IPDMCD00 H500607X;
label value IPDMCR00 H500608X;
label value IPDOFD00 H500609X;
label value IPDOPR00 H500610X;
label value IPDOPU00 H500611X;
label value IPDOSR00 H500612X;
label value IPDPRV00 H500613X;
label value IPDSLF00 H500614X;
label value IPDSTL00 H500615X;
label value IPDTCH00 H500616X;
label value IPDTRI00 H500617X;
label value IPDVA00 H500618X;
label value IPDWCP00 H500619X;
label value IPFEXP00 H500620X;
label value IPFMCD00 H500621X;
label value IPFMCR00 H500622X;
label value IPFOFD00 H500623X;
label value IPFOPR00 H500624X;
label value IPFOPU00 H500625X;
label value IPFOSR00 H500626X;
label value IPFPRV00 H500627X;
label value IPFSLF00 H500628X;
label value IPFSTL00 H500629X;
label value IPFTCH00 H500630X;
label value IPFTRI00 H500631X;
label value IPFVA00 H500632X;
label value IPFWCP00 H500633X;
label value IPNGTD00 H500634X;
label value IPZERO00 H500635X;
label value IRAIMP00 H500636X;
label value IRASP00X H500637X;
label value IRATAX00 H500638X;
label value ITMEXP00 H500639X;
label value JNTPID00 H500640X;
label value JOBORG31 H500641X;
label value JOBORG42 H500642X;
label value JOBORG53 H500643X;
label value JTINRU00 H500644X;
label value JTPAIN53 H500645X;
label value KEYNESS H500646X;
label value KIDPRO42 H500647X;
label value LANGBA42 H500648X;
label value LFTDIF31 H500649X;
label value LFTDIF53 H500650X;
label value LIFSKL42 H500651X;
label value LIKESU42 H500652X;
label value LIMACT42 H500653X;
label value LIMITOT H500654X;
label value LMOACT42 H500655X;
label value LMTBACK H500656X;
label value LOCATI42 H500657X;
label value LSTETH53 H500658X;
label value MAINPR42 H500659X;
label value MAMOGR53 H500660X;
label value MARRY00X H500661X;
label value MARRY31X H500662X;
label value MARRY42X H500663X;
label value MARRY53X H500664X;
label value MCAID00 H500665X;
label value MCAID00X H500666X;
label value MCAID31 H500667X;
label value MCAID31X H500668X;
label value MCAID42 H500669X;
label value MCAID42X H500670X;
label value MCAID53 H500671X;
label value MCAID53X H500672X;
label value MCARE00 H500673X;
label value MCARE00X H500674X;
label value MCARE31 H500675X;
label value MCARE31X H500676X;
label value MCARE42 H500677X;
label value MCARE42X H500678X;
label value MCARE53 H500679X;
label value MCARE53X H500680X;
label value MCDAP00 H500681X;
label value MCDAP00X H500682X;
label value MCDAT00X H500683X;
label value MCDAT31X H500684X;
label value MCDAT42X H500685X;
label value MCDAT53X H500686X;
label value MCDAU00 H500687X;
label value MCDAU00X H500688X;
label value MCDDE00 H500689X;
label value MCDDE00X H500690X;
label value MCDEV00 H500691X;
label value MCDFE00 H500692X;
label value MCDFE00X H500693X;
label value MCDHMO00 H500694X;
label value MCDHMO31 H500695X;
label value MCDHMO42 H500696X;
label value MCDJA00 H500697X;
label value MCDJA00X H500698X;
label value MCDJL00 H500699X;
label value MCDJL00X H500700X;
label value MCDJU00 H500701X;
label value MCDJU00X H500702X;
label value MCDMA00 H500703X;
label value MCDMA00X H500704X;
label value MCDMC00 H500705X;
label value MCDMC31 H500706X;
label value MCDMC42 H500707X;
label value MCDMY00 H500708X;
label value MCDMY00X H500709X;
label value MCDNO00 H500710X;
label value MCDNO00X H500711X;
label value MCDOC00 H500712X;
label value MCDOC00X H500713X;
label value MCDSE00 H500714X;
label value MCDSE00X H500715X;
label value MCRAP00 H500716X;
label value MCRAP00X H500717X;
label value MCRAU00 H500718X;
label value MCRAU00X H500719X;
label value MCRDE00 H500720X;
label value MCRDE00X H500721X;
label value MCREV00 H500722X;
label value MCRFE00 H500723X;
label value MCRFE00X H500724X;
label value MCRJA00 H500725X;
label value MCRJA00X H500726X;
label value MCRJL00 H500727X;
label value MCRJL00X H500728X;
label value MCRJU00 H500729X;
label value MCRJU00X H500730X;
label value MCRMA00 H500731X;
label value MCRMA00X H500732X;
label value MCRMY00 H500733X;
label value MCRMY00X H500734X;
label value MCRNO00 H500735X;
label value MCRNO00X H500736X;
label value MCROC00 H500737X;
label value MCROC00X H500738X;
label value MCRSE00 H500739X;
label value MCRSE00X H500740X;
label value MCS42 H500741X;
label value MEXAMT00 H500742X;
label value MIDX53 H500743X;
label value MILDIF31 H500744X;
label value MILDIF53 H500745X;
label value MINORP42 H500746X;
label value MMRSHT42 H500747X;
label value MNHLTH31 H500748X;
label value MNHLTH42 H500749X;
label value MNHLTH53 H500750X;
label value MNPROX31 H500751X;
label value MNPROX42 H500752X;
label value MNPROX53 H500753X;
label value MOMPRO42 H500754X;
label value MOPID31X H500755X;
label value MOPID42X H500756X;
label value MOPID53X H500757X;
label value MORE31 H500758X;
label value MORE42 H500759X;
label value MORE53 H500760X;
label value MORECOVR H500761X;
label value MORJOB31 H500762X;
label value MORJOB42 H500763X;
label value MORJOB53 H500764X;
label value MSA00 H500765X;
label value MSA31 H500766X;
label value MSA42 H500767X;
label value MSA53 H500768X;
label value MYSELF42 H500769X;
label value NERVAF42 H500770X;
label value NEWARE42 H500771X;
label value NOAFFO42 H500772X;
label value NOASPR53 H500773X;
label value NOCARE42 H500774X;
label value NOFAT53 H500775X;
label value NOINSBEF H500776X;
label value NOINSTM H500777X;
label value NOINUNIT H500778X;
label value NOOTHP42 H500779X;
label value NOREA942 H500780X;
label value NOREAS42 H500781X;
label value NOTIME42 H500782X;
label value NTHLTH42 H500783X;
label value NTMDED00 H500784X;
label value NUMDPT42 H500785X;
label value NUMEMP31 H500786X;
label value NUMEMP42 H500787X;
label value NUMEMP53 H500788X;
label value NUMPOL42 H500789X;
label value NWK31 H500790X;
label value NWK42 H500791X;
label value NWK53 H500792X;
label value OBAEXP00 H500793X;
label value OBAMCD00 H500794X;
label value OBAMCR00 H500795X;
label value OBAOFD00 H500796X;
label value OBAOPR00 H500797X;
label value OBAOPU00 H500798X;
label value OBAOSR00 H500799X;
label value OBAPRV00 H500800X;
label value OBASLF00 H500801X;
label value OBASST00 H500802X;
label value OBASTL00 H500803X;
label value OBATCH00 H500804X;
label value OBATRI00 H500805X;
label value OBAVA00 H500806X;
label value OBAWCP00 H500807X;
label value OBCEXP00 H500808X;
label value OBCHIR00 H500809X;
label value OBCMCD00 H500810X;
label value OBCMCR00 H500811X;
label value OBCOFD00 H500812X;
label value OBCOPR00 H500813X;
label value OBCOPU00 H500814X;
label value OBCOSR00 H500815X;
label value OBCPRV00 H500816X;
label value OBCSLF00 H500817X;
label value OBCSTL00 H500818X;
label value OBCTCH00 H500819X;
label value OBCTRI00 H500820X;
label value OBCVA00 H500821X;
label value OBCWCP00 H500822X;
label value OBDEXP00 H500823X;
label value OBDMCD00 H500824X;
label value OBDMCR00 H500825X;
label value OBDOFD00 H500826X;
label value OBDOPR00 H500827X;
label value OBDOPU00 H500828X;
label value OBDOSR00 H500829X;
label value OBDPRV00 H500830X;
label value OBDRV00 H500831X;
label value OBDSLF00 H500832X;
label value OBDSTL00 H500833X;
label value OBDTCH00 H500834X;
label value OBDTRI00 H500835X;
label value OBDVA00 H500836X;
label value OBDWCP00 H500837X;
label value OBEEXP00 H500838X;
label value OBEMCD00 H500839X;
label value OBEMCR00 H500840X;
label value OBEOFD00 H500841X;
label value OBEOPR00 H500842X;
label value OBEOPU00 H500843X;
label value OBEOSR00 H500844X;
label value OBEPRV00 H500845X;
label value OBESLF00 H500846X;
label value OBESTL00 H500847X;
label value OBETCH00 H500848X;
label value OBETRI00 H500849X;
label value OBEVA00 H500850X;
label value OBEWCP00 H500851X;
label value OBNEXP00 H500852X;
label value OBNMCD00 H500853X;
label value OBNMCR00 H500854X;
label value OBNOFD00 H500855X;
label value OBNOPR00 H500856X;
label value OBNOPU00 H500857X;
label value OBNOSR00 H500858X;
label value OBNPRV00 H500859X;
label value OBNSLF00 H500860X;
label value OBNSTL00 H500861X;
label value OBNTCH00 H500862X;
label value OBNTRI00 H500863X;
label value OBNURS00 H500864X;
label value OBNVA00 H500865X;
label value OBNWCP00 H500866X;
label value OBOEXP00 H500867X;
label value OBOMCD00 H500868X;
label value OBOMCR00 H500869X;
label value OBOOFD00 H500870X;
label value OBOOPR00 H500871X;
label value OBOOPU00 H500872X;
label value OBOOSR00 H500873X;
label value OBOPRV00 H500874X;
label value OBOPTO00 H500875X;
label value OBOSLF00 H500876X;
label value OBOSTL00 H500877X;
label value OBOTCH00 H500878X;
label value OBOTHV00 H500879X;
label value OBOTRI00 H500880X;
label value OBOVA00 H500881X;
label value OBOWCP00 H500882X;
label value OBTAIN42 H500883X;
label value OBTEXP00 H500884X;
label value OBTHER00 H500885X;
label value OBTMCD00 H500886X;
label value OBTMCR00 H500887X;
label value OBTOFD00 H500888X;
label value OBTOPR00 H500889X;
label value OBTOPU00 H500890X;
label value OBTOSR00 H500891X;
label value OBTOTV00 H500892X;
label value OBTPRV00 H500893X;
label value OBTSLF00 H500894X;
label value OBTSTL00 H500895X;
label value OBTTCH00 H500896X;
label value OBTTRI00 H500897X;
label value OBTVA00 H500898X;
label value OBTWCP00 H500899X;
label value OBVEXP00 H500900X;
label value OBVMCD00 H500901X;
label value OBVMCR00 H500902X;
label value OBVOFD00 H500903X;
label value OBVOPR00 H500904X;
label value OBVOPU00 H500905X;
label value OBVOSR00 H500906X;
label value OBVPRV00 H500907X;
label value OBVSLF00 H500908X;
label value OBVSTL00 H500909X;
label value OBVTCH00 H500910X;
label value OBVTRI00 H500911X;
label value OBVVA00 H500912X;
label value OBVWCP00 H500913X;
label value OCUPTH42 H500914X;
label value OFFER31X H500915X;
label value OFFER42X H500916X;
label value OFFER53X H500917X;
label value OFFHOU42 H500918X;
label value OFFICE42 H500919X;
label value OFFWOR42 H500920X;
label value OHRTDX53 H500921X;
label value OPAAP00 H500922X;
label value OPAAU00 H500923X;
label value OPADE00 H500924X;
label value OPAEV00 H500925X;
label value OPAFE00 H500926X;
label value OPAJA00 H500927X;
label value OPAJL00 H500928X;
label value OPAJU00 H500929X;
label value OPAMA00 H500930X;
label value OPAMY00 H500931X;
label value OPANO00 H500932X;
label value OPAOC00 H500933X;
label value OPASE00 H500934X;
label value OPBAP00 H500935X;
label value OPBAU00 H500936X;
label value OPBDE00 H500937X;
label value OPBEV00 H500938X;
label value OPBFE00 H500939X;
label value OPBJA00 H500940X;
label value OPBJL00 H500941X;
label value OPBJU00 H500942X;
label value OPBMA00 H500943X;
label value OPBMY00 H500944X;
label value OPBNO00 H500945X;
label value OPBOC00 H500946X;
label value OPBSE00 H500947X;
label value OPDEXP00 H500948X;
label value OPDMCD00 H500949X;
label value OPDMCR00 H500950X;
label value OPDOFD00 H500951X;
label value OPDOPR00 H500952X;
label value OPDOPU00 H500953X;
label value OPDOSR00 H500954X;
label value OPDPRV00 H500955X;
label value OPDRV00 H500956X;
label value OPDSLF00 H500957X;
label value OPDSTL00 H500958X;
label value OPDTCH00 H500959X;
label value OPDTRI00 H500960X;
label value OPDVA00 H500961X;
label value OPDWCP00 H500962X;
label value OPFEXP00 H500963X;
label value OPFMCD00 H500964X;
label value OPFMCR00 H500965X;
label value OPFOFD00 H500966X;
label value OPFOPR00 H500967X;
label value OPFOPU00 H500968X;
label value OPFOSR00 H500969X;
label value OPFPRV00 H500970X;
label value OPFSLF00 H500971X;
label value OPFSTL00 H500972X;
label value OPFTCH00 H500973X;
label value OPFTRI00 H500974X;
label value OPFVA00 H500975X;
label value OPFWCP00 H500976X;
label value OPOEXP00 H500977X;
label value OPOMCD00 H500978X;
label value OPOMCR00 H500979X;
label value OPOOFD00 H500980X;
label value OPOOPR00 H500981X;
label value OPOOPU00 H500982X;
label value OPOOSR00 H500983X;
label value OPOPRV00 H500984X;
label value OPOSLF00 H500985X;
label value OPOSTL00 H500986X;
label value OPOTCH00 H500987X;
label value OPOTHV00 H500988X;
label value OPOTRI00 H500989X;
label value OPOVA00 H500990X;
label value OPOWCP00 H500991X;
label value OPPEXP00 H500992X;
label value OPPMCD00 H500993X;
label value OPPMCR00 H500994X;
label value OPPOFD00 H500995X;
label value OPPOPR00 H500996X;
label value OPPOPU00 H500997X;
label value OPPOSR00 H500998X;
label value OPPPRV00 H500999X;
label value OPPSLF00 H501000X;
label value OPPSTL00 H501001X;
label value OPPTCH00 H501002X;
label value OPPTRI00 H501003X;
label value OPPVA00 H501004X;
label value OPPWCP00 H501005X;
label value OPSEXP00 H501006X;
label value OPSMCD00 H501007X;
label value OPSMCR00 H501008X;
label value OPSOFD00 H501009X;
label value OPSOPR00 H501010X;
label value OPSOPU00 H501011X;
label value OPSOSR00 H501012X;
label value OPSPRV00 H501013X;
label value OPSSLF00 H501014X;
label value OPSSTL00 H501015X;
label value OPSTCH00 H501016X;
label value OPSTRI00 H501017X;
label value OPSVA00 H501018X;
label value OPSWCP00 H501019X;
label value OPTOTV00 H501020X;
label value OPVEXP00 H501021X;
label value OPVMCD00 H501022X;
label value OPVMCR00 H501023X;
label value OPVOFD00 H501024X;
label value OPVOPR00 H501025X;
label value OPVOPU00 H501026X;
label value OPVOSR00 H501027X;
label value OPVPRV00 H501028X;
label value OPVSLF00 H501029X;
label value OPVSTL00 H501030X;
label value OPVTCH00 H501031X;
label value OPVTRI00 H501032X;
label value OPVVA00 H501033X;
label value OPVWCP00 H501034X;
label value OTHDYS31 H501035X;
label value OTHDYS42 H501036X;
label value OTHDYS53 H501037X;
label value OTHEXP00 H501038X;
label value OTHIMP00 H501039X;
label value OTHINS42 H501040X;
label value OTHMCD00 H501041X;
label value OTHMCR00 H501042X;
label value OTHNDD31 H501043X;
label value OTHNDD42 H501044X;
label value OTHNDD53 H501045X;
label value OTHOFD00 H501046X;
label value OTHOPR00 H501047X;
label value OTHOPU00 H501048X;
label value OTHOSR00 H501049X;
label value OTHPRV00 H501050X;
label value OTHRE942 H501051X;
label value OTHREA42 H501052X;
label value OTHRP00X H501053X;
label value OTHRPR42 H501054X;
label value OTHSLF00 H501055X;
label value OTHSTL00 H501056X;
label value OTHSVC42 H501057X;
label value OTHTCH00 H501058X;
label value OTHTRI00 H501059X;
label value OTHVA00 H501060X;
label value OTHWCP00 H501061X;
label value OTPAAT00 H501062X;
label value OTPAAT31 H501063X;
label value OTPAAT42 H501064X;
label value OTPAAT53 H501065X;
label value OTPBAT00 H501066X;
label value OTPBAT31 H501067X;
label value OTPBAT42 H501068X;
label value OTPBAT53 H501069X;
label value OTPUBA00 H501070X;
label value OTPUBA31 H501071X;
label value OTPUBA42 H501072X;
label value OTPUBA53 H501073X;
label value OTPUBB00 H501074X;
label value OTPUBB31 H501075X;
label value OTPUBB42 H501076X;
label value OTPUBB53 H501077X;
label value PANEL00 H501078X;
label value PAPSMR53 H501079X;
label value PAYDR31 H501080X;
label value PAYDR42 H501081X;
label value PAYDR53 H501082X;
label value PAYVAC31 H501083X;
label value PAYVAC42 H501084X;
label value PAYVAC53 H501085X;
label value PCS42 H501086X;
label value PDKAP00 H501087X;
label value PDKAU00 H501088X;
label value PDKDE00 H501089X;
label value PDKFE00 H501090X;
label value PDKJA00 H501091X;
label value PDKJL00 H501092X;
label value PDKJU00 H501093X;
label value PDKMA00 H501094X;
label value PDKMY00 H501095X;
label value PDKNO00 H501096X;
label value PDKOC00 H501097X;
label value PDKSE00 H501098X;
label value PEGAP00 H501099X;
label value PEGAU00 H501100X;
label value PEGDE00 H501101X;
label value PEGFE00 H501102X;
label value PEGJA00 H501103X;
label value PEGJL00 H501104X;
label value PEGJU00 H501105X;
label value PEGMA00 H501106X;
label value PEGMY00 H501107X;
label value PEGNO00 H501108X;
label value PEGOC00 H501109X;
label value PEGSE00 H501110X;
label value PENIMP00 H501111X;
label value PENSP00X H501112X;
label value PERSLA42 H501113X;
label value PHONED42 H501114X;
label value PHYACT53 H501115X;
label value PHYTHR42 H501116X;
label value PLYLIM42 H501117X;
label value PMEDIN31 H501118X;
label value PMEDIN42 H501119X;
label value PMEDIN53 H501120X;
label value PNGAP00 H501121X;
label value PNGAU00 H501122X;
label value PNGDE00 H501123X;
label value PNGFE00 H501124X;
label value PNGJA00 H501125X;
label value PNGJL00 H501126X;
label value PNGJU00 H501127X;
label value PNGMA00 H501128X;
label value PNGMY00 H501129X;
label value PNGNO00 H501130X;
label value PNGOC00 H501131X;
label value PNGSE00 H501132X;
label value POGAP00 H501133X;
label value POGAU00 H501134X;
label value POGDE00 H501135X;
label value POGFE00 H501136X;
label value POGJA00 H501137X;
label value POGJL00 H501138X;
label value POGJU00 H501139X;
label value POGMA00 H501140X;
label value POGMY00 H501141X;
label value POGNO00 H501142X;
label value POGOC00 H501143X;
label value POGSE00 H501144X;
label value POLSHT42 H501145X;
label value POUAP00 H501146X;
label value POUAU00 H501147X;
label value POUDE00 H501148X;
label value POUFE00 H501149X;
label value POUJA00 H501150X;
label value POUJL00 H501151X;
label value POUJU00 H501152X;
label value POUMA00 H501153X;
label value POUMY00 H501154X;
label value POUNO00 H501155X;
label value POUOC00 H501156X;
label value POUSE00 H501157X;
label value POVCAT00 H501158X;
label value PREEXC42 H501159X;
label value PREVCOVR H501160X;
label value PREVEN42 H501161X;
label value PRIAP00 H501162X;
label value PRIAU00 H501163X;
label value PRIDE00 H501164X;
label value PRIDK00 H501165X;
label value PRIDK31 H501166X;
label value PRIDK42 H501167X;
label value PRIDK53 H501168X;
label value PRIEU00 H501169X;
label value PRIEU31 H501170X;
label value PRIEU42 H501171X;
label value PRIEU53 H501172X;
label value PRIFE00 H501173X;
label value PRIJA00 H501174X;
label value PRIJL00 H501175X;
label value PRIJU00 H501176X;
label value PRIMA00 H501177X;
label value PRIMY00 H501178X;
label value PRING00 H501179X;
label value PRING31 H501180X;
label value PRING42 H501181X;
label value PRING53 H501182X;
label value PRINO00 H501183X;
label value PRIOC00 H501184X;
label value PRIOG00 H501185X;
label value PRIOG31 H501186X;
label value PRIOG42 H501187X;
label value PRIOG53 H501188X;
label value PRIS00 H501189X;
label value PRIS31 H501190X;
label value PRIS42 H501191X;
label value PRIS53 H501192X;
label value PRISE00 H501193X;
label value PRIV00 H501194X;
label value PRIV31 H501195X;
label value PRIV42 H501196X;
label value PRIV53 H501197X;
label value PRIVAT00 H501198X;
label value PRIVAT31 H501199X;
label value PRIVAT42 H501200X;
label value PRIVAT53 H501201X;
label value PRLIST42 H501202X;
label value PROUT00 H501203X;
label value PROUT31 H501204X;
label value PROUT42 H501205X;
label value PROUT53 H501206X;
label value PROVST42 H501207X;
label value PROVTY42 H501208X;
label value PROXY00 H501209X;
label value PROXY31 H501210X;
label value PROXY42 H501211X;
label value PROXY53 H501212X;
label value PRSAP00 H501213X;
label value PRSAU00 H501214X;
label value PRSDE00 H501215X;
label value PRSFE00 H501216X;
label value PRSJA00 H501217X;
label value PRSJL00 H501218X;
label value PRSJU00 H501219X;
label value PRSMA00 H501220X;
label value PRSMY00 H501221X;
label value PRSNO00 H501222X;
label value PRSOC00 H501223X;
label value PRSSE00 H501224X;
label value PRVEV00 H501225X;
label value PRVHMO00 H501226X;
label value PRVHMO31 H501227X;
label value PRVHMO42 H501228X;
label value PRVMNC00 H501229X;
label value PRVMNC31 H501230X;
label value PRVMNC42 H501231X;
label value PSA53 H501232X;
label value PSTATS31 H501233X;
label value PSTATS42 H501234X;
label value PSTATS53 H501235X;
label value PSYCNS42 H501236X;
label value PUB00X H501237X;
label value PUB31X H501238X;
label value PUB42X H501239X;
label value PUB53X H501240X;
label value PUBAP00X H501241X;
label value PUBAT00X H501242X;
label value PUBAT31X H501243X;
label value PUBAT42X H501244X;
label value PUBAT53X H501245X;
label value PUBAU00X H501246X;
label value PUBDE00X H501247X;
label value PUBFE00X H501248X;
label value PUBIMP00 H501249X;
label value PUBJA00X H501250X;
label value PUBJL00X H501251X;
label value PUBJU00X H501252X;
label value PUBMA00X H501253X;
label value PUBMY00X H501254X;
label value PUBNO00X H501255X;
label value PUBOC00X H501256X;
label value PUBP00X H501257X;
label value PUBSE00X H501258X;
label value PUBTRA42 H501259X;
label value RACETHNX H501260X;
label value RACEX H501261X;
label value RCHDIF31 H501262X;
label value RCHDIF53 H501263X;
label value READIN42 H501264X;
label value READNW42 H501265X;
label value RECPEP42 H501266X;
label value RECTHR42 H501267X;
label value REFDP00X H501268X;
label value REFFRL42 H501269X;
label value REFIMP00 H501270X;
label value REFUSE42 H501271X;
label value REFUSI42 H501272X;
label value REGION00 H501273X;
label value REGION31 H501274X;
label value REGION42 H501275X;
label value REGION53 H501276X;
label value RESP00 H501277X;
label value RESP31 H501278X;
label value RESP42 H501279X;
label value RESP53 H501280X;
label value RETPLN31 H501281X;
label value RETPLN42 H501282X;
label value RETPLN53 H501283X;
label value RFREL00X H501284X;
label value RFREL31X H501285X;
label value RFREL42X H501286X;
label value RFREL53X H501287X;
label value RNDFLG31 H501288X;
label value RTHLTH31 H501289X;
label value RTHLTH42 H501290X;
label value RTHLTH53 H501291X;
label value RTPROX31 H501292X;
label value RTPROX42 H501293X;
label value RTPROX53 H501294X;
label value RUCLAS00 H501295X;
label value RUCLAS31 H501296X;
label value RUCLAS42 H501297X;
label value RUCLAS53 H501298X;
label value RUSIZE00 H501299X;
label value RUSIZE31 H501300X;
label value RUSIZE42 H501301X;
label value RUSIZE53 H501302X;
label value RXEXP00 H501303X;
label value RXMCD00 H501304X;
label value RXMCR00 H501305X;
label value RXOFD00 H501306X;
label value RXOPR00 H501307X;
label value RXOPU00 H501308X;
label value RXOSR00 H501309X;
label value RXPRV00 H501310X;
label value RXSLF00 H501311X;
label value RXSTL00 H501312X;
label value RXTOT00 H501313X;
label value RXTRI00 H501314X;
label value RXVA00 H501315X;
label value RXWCP00 H501316X;
label value SALIMP00 H501317X;
label value SCHLBH42 H501318X;
label value SCHLIM31 H501319X;
label value SCHLIM53 H501320X;
label value SCHPRO42 H501321X;
label value SCLNBD31 H501322X;
label value SCLNBD42 H501323X;
label value SCLNBD53 H501324X;
label value SEATBE53 H501325X;
label value SEEDIF42 H501326X;
label value SELDSI42 H501327X;
label value SELFCM31 H501328X;
label value SELFCM42 H501329X;
label value SELFCM53 H501330X;
label value SEX H501331X;
label value SFFLAG42 H501332X;
label value SHFTWK31 H501333X;
label value SHFTWK42 H501334X;
label value SHFTWK53 H501335X;
label value SIBPRO42 H501336X;
label value SICPAY31 H501337X;
label value SICPAY42 H501338X;
label value SICPAY53 H501339X;
label value SOCLIM31 H501340X;
label value SOCLIM53 H501341X;
label value SPCHTH42 H501342X;
label value SPCPRO42 H501343X;
label value SPCSCH42 H501344X;
label value SPECED42 H501345X;
label value SPOUID00 H501346X;
label value SPOUID31 H501347X;
label value SPOUID42 H501348X;
label value SPOUID53 H501349X;
label value SPOUIN00 H501350X;
label value SPOUIN31 H501351X;
label value SPOUIN42 H501352X;
label value SPOUIN53 H501353X;
label value SPRPRO42 H501354X;
label value SSCIMP00 H501355X;
label value SSECP00X H501356X;
label value SSECTX00 H501357X;
label value SSIDIS00 H501358X;
label value SSIIMP00 H501359X;
label value SSIP00X H501360X;
label value STAAP00 H501361X;
label value STAAU00 H501362X;
label value STADE00 H501363X;
label value STAFE00 H501364X;
label value STAJA00 H501365X;
label value STAJL00 H501366X;
label value STAJU00 H501367X;
label value STAMA00 H501368X;
label value STAMY00 H501369X;
label value STANO00 H501370X;
label value STAOC00 H501371X;
label value STAPR00 H501372X;
label value STAPR31 H501373X;
label value STAPR42 H501374X;
label value STAPR53 H501375X;
label value STASE00 H501376X;
label value STJBDD31 H501377X;
label value STJBDD42 H501378X;
label value STJBDD53 H501379X;
label value STJBMM31 H501380X;
label value STJBMM42 H501381X;
label value STJBMM53 H501382X;
label value STJBYY31 H501383X;
label value STJBYY42 H501384X;
label value STJBYY53 H501385X;
label value STNDIF31 H501386X;
label value STNDIF53 H501387X;
label value STOMCH53 H501388X;
label value STOOL53 H501389X;
label value STPDIF31 H501390X;
label value STPDIF53 H501391X;
label value STPRAT00 H501392X;
label value STPRAT31 H501393X;
label value STPRAT42 H501394X;
label value STPRAT53 H501395X;
label value STRKDX53 H501396X;
label value SVERLANG H501397X;
label value TAXFRM00 H501398X;
label value TOTDED00 H501399X;
label value TOTEXP00 H501400X;
label value TOTMCD00 H501401X;
label value TOTMCR00 H501402X;
label value TOTOFD00 H501403X;
label value TOTOPR00 H501404X;
label value TOTOPU00 H501405X;
label value TOTOSR00 H501406X;
label value TOTPRV00 H501407X;
label value TOTSLF00 H501408X;
label value TOTSTL00 H501409X;
label value TOTTCH00 H501410X;
label value TOTTRI00 H501411X;
label value TOTVA00 H501412X;
label value TOTWCP00 H501413X;
label value TRBLE42 H501414X;
label value TREATM42 H501415X;
label value TRIAP00X H501416X;
label value TRIAT00X H501417X;
label value TRIAT31X H501418X;
label value TRIAT42X H501419X;
label value TRIAT53X H501420X;
label value TRIAU00X H501421X;
label value TRICR00X H501422X;
label value TRICR31X H501423X;
label value TRICR42X H501424X;
label value TRICR53X H501425X;
label value TRIDE00X H501426X;
label value TRIEV00 H501427X;
label value TRIFE00X H501428X;
label value TRIJA00X H501429X;
label value TRIJL00X H501430X;
label value TRIJU00X H501431X;
label value TRIMA00X H501432X;
label value TRIMY00X H501433X;
label value TRINO00X H501434X;
label value TRIOC00X H501435X;
label value TRISE00X H501436X;
label value TRTIMP00 H501437X;
label value TTLP00X H501438X;
label value TUTOR42 H501439X;
label value TYPEPE42 H501440X;
label value TYPEPL42 H501441X;
label value UNABLE31 H501442X;
label value UNABLE53 H501443X;
label value UNEIMP00 H501444X;
label value UNEMP00X H501445X;
label value UNEMTX00 H501446X;
label value UNHAP42 H501447X;
label value UNINS00 H501448X;
label value UNION31 H501449X;
label value UNION42 H501450X;
label value UNION53 H501451X;
label value USCNOT42 H501452X;
label value USCQUA42 H501453X;
label value VETIMP00 H501454X;
label value VETKOR H501455X;
label value VETOTH H501456X;
label value VETSP00X H501457X;
label value VETVIET H501458X;
label value VETWW H501459X;
label value VISEXP00 H501460X;
label value VISION42 H501461X;
label value VISMCD00 H501462X;
label value VISMCR00 H501463X;
label value VISOFD00 H501464X;
label value VISOPR00 H501465X;
label value VISOPU00 H501466X;
label value VISOSR00 H501467X;
label value VISPRV00 H501468X;
label value VISSLF00 H501469X;
label value VISSTL00 H501470X;
label value VISTCH00 H501471X;
label value VISTRI00 H501472X;
label value VISVA00 H501473X;
label value VISWCP00 H501474X;
label value VOCSVC42 H501475X;
label value WAGEP00X H501476X;
label value WAGIMP00 H501477X;
label value WAITTI42 H501478X;
label value WASAFDC H501479X;
label value WASCHAMP H501480X;
label value WASESTB H501481X;
label value WASMCAID H501482X;
label value WASMCARE H501483X;
label value WASOTGOV H501484X;
label value WASOTHER H501485X;
label value WASPRIV H501486X;
label value WASSSI H501487X;
label value WASSTAT1 H501488X;
label value WASSTAT2 H501489X;
label value WASVA H501490X;
label value WCMPP00X H501491X;
label value WCPIMP00 H501492X;
label value WEIGHT53 H501493X;
label value WGTEST53 H501494X;
label value WGTLB42 H501495X;
label value WGTOZ42 H501496X;
label value WHENST53 H501497X;
label value WHNBWL53 H501498X;
label value WHOCAR00 H501499X;
label value WHRCAR00 H501500X;
label value WILFIL00 H501501X;
label value WKINBD31 H501502X;
label value WKINBD42 H501503X;
label value WKINBD53 H501504X;
label value WLKDIF31 H501505X;
label value WLKDIF53 H501506X;
label value WLKLIM31 H501507X;
label value WLKLIM53 H501508X;
label value WRGLAS42 H501509X;
label value WRKLIM31 H501510X;
label value WRKLIM53 H501511X;
label value YCHJ3142 H501512X;
label value YCHJ4253 H501513X;
label value YCHNGU42 H501514X;
label value YGOTOU42 H501515X;
label value YNOMOR42 H501516X;
label value YNOUSC42 H501517X;
label value ZIDEXP00 H501518X;
label value ZIDMCD00 H501519X;
label value ZIDMCR00 H501520X;
label value ZIDOFD00 H501521X;
label value ZIDOPR00 H501522X;
label value ZIDOPU00 H501523X;
label value ZIDOSR00 H501524X;
label value ZIDPRV00 H501525X;
label value ZIDSLF00 H501526X;
label value ZIDSTL00 H501527X;
label value ZIDTCH00 H501528X;
label value ZIDTRI00 H501529X;
label value ZIDVA00 H501530X;
label value ZIDWCP00 H501531X;
label value ZIFEXP00 H501532X;
label value ZIFMCD00 H501533X;
label value ZIFMCR00 H501534X;
label value ZIFOFD00 H501535X;
label value ZIFOPR00 H501536X;
label value ZIFOPU00 H501537X;
label value ZIFOSR00 H501538X;
label value ZIFPRV00 H501539X;
label value ZIFSLF00 H501540X;
label value ZIFSTL00 H501541X;
label value ZIFTCH00 H501542X;
label value ZIFTRI00 H501543X;
label value ZIFVA00 H501544X;
label value ZIFWCP00 H501545X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H50.LOG and a data file named H50.DTA.  If these files (H50.DTA and H50.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

